% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tguh_decomp.R
\name{tguh.decomp}
\alias{tguh.decomp}
\title{The Tail-Greedy Unbalanced Haar decomposition of a vector}
\usage{
tguh.decomp(x, p = 0.01)
}
\arguments{
\item{x}{A vector you wish to decompose.}

\item{p}{Specifies the number of region pairs merged 
in each pass through the data, as the proportion of all remaining region pairs. The default is
0.01.}
}
\value{
A list with the following components:
\item{n}{The length of \code{x}.}
\item{decomp.hist}{The decomposition history: the complete record of the \code{n}-1 steps taken to decompose \code{x}.
This is an array of dimensions 4 by 2 by \code{n}-1. Each of the \code{n}-1 matrices of dimensions 4 by 2
contains the following: first row - the indices of the regions merged, in increasing order (note: the indexing changes
through the transform); second row - the values of the Unbalanced Haar filter coefficients used to produce the
corresponding detail coefficient; third row - the (detail coefficient, smooth coefficient) of the decomposition;
fourth row - the lengths of (left wing, right wing) of the corresponding Unbalanced Haar wavelet.}
\item{tguh.coeffs}{The coefficients of the Tail-Greedy Unbalanced Haar transform of \code{x}.}
}
\description{
This function performs the Tail-Greedy Unbalanced Haar decomposition of the input
vector.
}
\details{
The Tail-Greedy Unbalanced Haar decomposition algorithm is described in 
"Tail-greedy bottom-up data decompositions and fast multiple change-point 
detection", P. Fryzlewicz (2017), preprint.
}
\examples{
rnoise <- rnorm(10)
tguh.decomp(rnoise)
}
\seealso{
\code{\link{tguh.cpt}}, \code{\link{tguh.denoise}}, \code{\link{tguh.reconstr}}
}
\author{
Piotr Fryzlewicz, \email{p.fryzlewicz@lse.ac.uk}
}
