// Generated by rstantools.  Do not edit by hand.

/*
    breathteststan is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    breathteststan is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with breathteststan.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_breath_test_1_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_breath_test_1");
    reader.add_event(78, 76, "end", "model_breath_test_1");
    return reader;
}
#include <stan_meta_header.hpp>
class model_breath_test_1
  : public stan::model::model_base_crtp<model_breath_test_1> {
private:
        int n;
        int n_record;
        int student_t_df;
        double dose;
        std::vector<int> pat_group_i;
        vector_d minute;
        vector_d pdr;
public:
    model_breath_test_1(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_breath_test_1(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_breath_test_1_namespace::model_breath_test_1";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 4;
            context__.validate_dims("data initialization", "n", "int", context__.to_vec());
            n = int(0);
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            n = vals_i__[pos__++];
            check_greater_or_equal(function__, "n", n, 0);
            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "n_record", "int", context__.to_vec());
            n_record = int(0);
            vals_i__ = context__.vals_i("n_record");
            pos__ = 0;
            n_record = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_record", n_record, 0);
            current_statement_begin__ = 6;
            context__.validate_dims("data initialization", "student_t_df", "int", context__.to_vec());
            student_t_df = int(0);
            vals_i__ = context__.vals_i("student_t_df");
            pos__ = 0;
            student_t_df = vals_i__[pos__++];
            check_greater_or_equal(function__, "student_t_df", student_t_df, 1);
            current_statement_begin__ = 7;
            context__.validate_dims("data initialization", "dose", "double", context__.to_vec());
            dose = double(0);
            vals_r__ = context__.vals_r("dose");
            pos__ = 0;
            dose = vals_r__[pos__++];
            check_greater_or_equal(function__, "dose", dose, 0);
            current_statement_begin__ = 8;
            validate_non_negative_index("pat_group_i", "n", n);
            context__.validate_dims("data initialization", "pat_group_i", "int", context__.to_vec(n));
            pat_group_i = std::vector<int>(n, int(0));
            vals_i__ = context__.vals_i("pat_group_i");
            pos__ = 0;
            size_t pat_group_i_k_0_max__ = n;
            for (size_t k_0__ = 0; k_0__ < pat_group_i_k_0_max__; ++k_0__) {
                pat_group_i[k_0__] = vals_i__[pos__++];
            }
            size_t pat_group_i_i_0_max__ = n;
            for (size_t i_0__ = 0; i_0__ < pat_group_i_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "pat_group_i[i_0__]", pat_group_i[i_0__], 0);
            }
            current_statement_begin__ = 9;
            validate_non_negative_index("minute", "n", n);
            context__.validate_dims("data initialization", "minute", "vector_d", context__.to_vec(n));
            minute = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("minute");
            pos__ = 0;
            size_t minute_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < minute_j_1_max__; ++j_1__) {
                minute(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "minute", minute, 0);
            current_statement_begin__ = 10;
            validate_non_negative_index("pdr", "n", n);
            context__.validate_dims("data initialization", "pdr", "vector_d", context__.to_vec(n));
            pdr = Eigen::Matrix<double, Eigen::Dynamic, 1>(n);
            vals_r__ = context__.vals_r("pdr");
            pos__ = 0;
            size_t pdr_j_1_max__ = n;
            for (size_t j_1__ = 0; j_1__ < pdr_j_1_max__; ++j_1__) {
                pdr(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "pdr", pdr, -(30));
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 14;
            validate_non_negative_index("m_raw", "n_record", n_record);
            num_params_r__ += n_record;
            current_statement_begin__ = 15;
            num_params_r__ += 1;
            current_statement_begin__ = 16;
            num_params_r__ += 1;
            current_statement_begin__ = 18;
            validate_non_negative_index("k_raw", "n_record", n_record);
            num_params_r__ += n_record;
            current_statement_begin__ = 19;
            num_params_r__ += 1;
            current_statement_begin__ = 20;
            num_params_r__ += 1;
            current_statement_begin__ = 22;
            validate_non_negative_index("beta_raw", "n_record", n_record);
            num_params_r__ += n_record;
            current_statement_begin__ = 23;
            num_params_r__ += 1;
            current_statement_begin__ = 24;
            num_params_r__ += 1;
            current_statement_begin__ = 26;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_breath_test_1() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 14;
        if (!(context__.contains_r("m_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable m_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("m_raw");
        pos__ = 0U;
        validate_non_negative_index("m_raw", "n_record", n_record);
        context__.validate_dims("parameter initialization", "m_raw", "vector_d", context__.to_vec(n_record));
        Eigen::Matrix<double, Eigen::Dynamic, 1> m_raw(n_record);
        size_t m_raw_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < m_raw_j_1_max__; ++j_1__) {
            m_raw(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(m_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable m_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 15;
        if (!(context__.contains_r("mu_m")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu_m missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu_m");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "mu_m", "double", context__.to_vec());
        double mu_m(0);
        mu_m = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, mu_m);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu_m: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 16;
        if (!(context__.contains_r("sigma_m")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_m missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_m");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma_m", "double", context__.to_vec());
        double sigma_m(0);
        sigma_m = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma_m);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_m: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 18;
        if (!(context__.contains_r("k_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable k_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("k_raw");
        pos__ = 0U;
        validate_non_negative_index("k_raw", "n_record", n_record);
        context__.validate_dims("parameter initialization", "k_raw", "vector_d", context__.to_vec(n_record));
        Eigen::Matrix<double, Eigen::Dynamic, 1> k_raw(n_record);
        size_t k_raw_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < k_raw_j_1_max__; ++j_1__) {
            k_raw(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(k_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable k_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 19;
        if (!(context__.contains_r("mu_k")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu_k missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu_k");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "mu_k", "double", context__.to_vec());
        double mu_k(0);
        mu_k = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, mu_k);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu_k: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 20;
        if (!(context__.contains_r("sigma_k")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_k missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_k");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma_k", "double", context__.to_vec());
        double sigma_k(0);
        sigma_k = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma_k);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_k: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 22;
        if (!(context__.contains_r("beta_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta_raw");
        pos__ = 0U;
        validate_non_negative_index("beta_raw", "n_record", n_record);
        context__.validate_dims("parameter initialization", "beta_raw", "vector_d", context__.to_vec(n_record));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta_raw(n_record);
        size_t beta_raw_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < beta_raw_j_1_max__; ++j_1__) {
            beta_raw(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 23;
        if (!(context__.contains_r("mu_beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable mu_beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("mu_beta");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "mu_beta", "double", context__.to_vec());
        double mu_beta(0);
        mu_beta = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, mu_beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable mu_beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 24;
        if (!(context__.contains_r("sigma_beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma_beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma_beta");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma_beta", "double", context__.to_vec());
        double sigma_beta(0);
        sigma_beta = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma_beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma_beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 26;
        if (!(context__.contains_r("sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "sigma", "double", context__.to_vec());
        double sigma(0);
        sigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, sigma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 14;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> m_raw;
            (void) m_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                m_raw = in__.vector_constrain(n_record, lp__);
            else
                m_raw = in__.vector_constrain(n_record);
            current_statement_begin__ = 15;
            local_scalar_t__ mu_m;
            (void) mu_m;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_m = in__.scalar_lb_constrain(0, lp__);
            else
                mu_m = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 16;
            local_scalar_t__ sigma_m;
            (void) sigma_m;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_m = in__.scalar_lb_constrain(0, lp__);
            else
                sigma_m = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 18;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> k_raw;
            (void) k_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                k_raw = in__.vector_constrain(n_record, lp__);
            else
                k_raw = in__.vector_constrain(n_record);
            current_statement_begin__ = 19;
            local_scalar_t__ mu_k;
            (void) mu_k;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_k = in__.scalar_lb_constrain(0, lp__);
            else
                mu_k = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 20;
            local_scalar_t__ sigma_k;
            (void) sigma_k;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_k = in__.scalar_lb_constrain(0, lp__);
            else
                sigma_k = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 22;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta_raw;
            (void) beta_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                beta_raw = in__.vector_constrain(n_record, lp__);
            else
                beta_raw = in__.vector_constrain(n_record);
            current_statement_begin__ = 23;
            local_scalar_t__ mu_beta;
            (void) mu_beta;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_beta = in__.scalar_lb_constrain(0, lp__);
            else
                mu_beta = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 24;
            local_scalar_t__ sigma_beta;
            (void) sigma_beta;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma_beta = in__.scalar_lb_constrain(0, lp__);
            else
                sigma_beta = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 26;
            local_scalar_t__ sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.scalar_lb_constrain(0, lp__);
            else
                sigma = in__.scalar_lb_constrain(0);
            // transformed parameters
            current_statement_begin__ = 31;
            validate_non_negative_index("m", "n_record", n_record);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> m(n_record);
            stan::math::initialize(m, DUMMY_VAR__);
            stan::math::fill(m, DUMMY_VAR__);
            current_statement_begin__ = 32;
            validate_non_negative_index("k", "n_record", n_record);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> k(n_record);
            stan::math::initialize(k, DUMMY_VAR__);
            stan::math::fill(k, DUMMY_VAR__);
            current_statement_begin__ = 33;
            validate_non_negative_index("beta", "n_record", n_record);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta(n_record);
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 36;
            stan::math::assign(m, add(mu_m, multiply(sigma_m, m_raw)));
            current_statement_begin__ = 37;
            stan::math::assign(k, add(mu_k, multiply(sigma_k, k_raw)));
            current_statement_begin__ = 38;
            stan::math::assign(beta, add(mu_beta, multiply(sigma_beta, beta_raw)));
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 31;
            size_t m_j_1_max__ = n_record;
            for (size_t j_1__ = 0; j_1__ < m_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(m(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: m" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable m: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "m", m, 0);
            current_statement_begin__ = 32;
            size_t k_j_1_max__ = n_record;
            for (size_t j_1__ = 0; j_1__ < k_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(k(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: k" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable k: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "k", k, 0);
            current_statement_begin__ = 33;
            size_t beta_j_1_max__ = n_record;
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(beta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable beta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "beta", beta, 0);
            // model body
            current_statement_begin__ = 43;
            lp_accum__.add(normal_log<propto__>(m_raw, 0, 1));
            current_statement_begin__ = 44;
            lp_accum__.add(normal_log<propto__>(mu_m, 40, 30));
            current_statement_begin__ = 45;
            lp_accum__.add(cauchy_log<propto__>(sigma_m, 0, 10));
            current_statement_begin__ = 47;
            lp_accum__.add(normal_log<propto__>(k_raw, 0, 1));
            current_statement_begin__ = 48;
            lp_accum__.add(lognormal_log<propto__>(mu_k, -(5), 2));
            current_statement_begin__ = 49;
            lp_accum__.add(lognormal_log<propto__>(sigma_k, -(7), 2));
            current_statement_begin__ = 51;
            lp_accum__.add(normal_log<propto__>(beta_raw, 0, 1));
            current_statement_begin__ = 52;
            lp_accum__.add(normal_log<propto__>(mu_beta, 2, 0.5));
            current_statement_begin__ = 53;
            lp_accum__.add(cauchy_log<propto__>(sigma_beta, 0, 2));
            current_statement_begin__ = 55;
            lp_accum__.add(cauchy_log<propto__>(sigma, 0, 5));
            {
            current_statement_begin__ = 57;
            validate_non_negative_index("pdr1", "n", n);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> pdr1(n);
            stan::math::initialize(pdr1, DUMMY_VAR__);
            stan::math::fill(pdr1, DUMMY_VAR__);
            current_statement_begin__ = 58;
            for (int i = 1; i <= n; ++i) {
                {
                current_statement_begin__ = 59;
                int rec(0);
                (void) rec;  // dummy to suppress unused var warning
                stan::math::fill(rec, std::numeric_limits<int>::min());
                current_statement_begin__ = 60;
                local_scalar_t__ mn(DUMMY_VAR__);
                (void) mn;  // dummy to suppress unused var warning
                stan::math::initialize(mn, DUMMY_VAR__);
                stan::math::fill(mn, DUMMY_VAR__);
                current_statement_begin__ = 61;
                local_scalar_t__ exp_ktn(DUMMY_VAR__);
                (void) exp_ktn;  // dummy to suppress unused var warning
                stan::math::initialize(exp_ktn, DUMMY_VAR__);
                stan::math::fill(exp_ktn, DUMMY_VAR__);
                current_statement_begin__ = 62;
                local_scalar_t__ kn(DUMMY_VAR__);
                (void) kn;  // dummy to suppress unused var warning
                stan::math::initialize(kn, DUMMY_VAR__);
                stan::math::fill(kn, DUMMY_VAR__);
                current_statement_begin__ = 63;
                local_scalar_t__ betan(DUMMY_VAR__);
                (void) betan;  // dummy to suppress unused var warning
                stan::math::initialize(betan, DUMMY_VAR__);
                stan::math::fill(betan, DUMMY_VAR__);
                current_statement_begin__ = 64;
                stan::math::assign(rec, get_base1(pat_group_i, i, "pat_group_i", 1));
                current_statement_begin__ = 65;
                stan::math::assign(mn, get_base1(m, rec, "m", 1));
                current_statement_begin__ = 66;
                stan::math::assign(kn, get_base1(k, rec, "k", 1));
                current_statement_begin__ = 67;
                stan::math::assign(exp_ktn, stan::math::exp((-(kn) * get_base1(minute, i, "minute", 1))));
                current_statement_begin__ = 68;
                stan::math::assign(betan, get_base1(beta, rec, "beta", 1));
                current_statement_begin__ = 69;
                stan::model::assign(pdr1, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (((((dose * mn) * kn) * betan) * exp_ktn) * pow((1 - exp_ktn), (betan - 1))), 
                            "assigning variable pdr1");
                }
            }
            current_statement_begin__ = 71;
            if (as_bool(logical_lt(student_t_df, 10))) {
                current_statement_begin__ = 72;
                lp_accum__.add(student_t_log<propto__>(pdr, student_t_df, pdr1, sigma));
            } else {
                current_statement_begin__ = 74;
                lp_accum__.add(normal_log<propto__>(pdr, pdr1, sigma));
            }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("m_raw");
        names__.push_back("mu_m");
        names__.push_back("sigma_m");
        names__.push_back("k_raw");
        names__.push_back("mu_k");
        names__.push_back("sigma_k");
        names__.push_back("beta_raw");
        names__.push_back("mu_beta");
        names__.push_back("sigma_beta");
        names__.push_back("sigma");
        names__.push_back("m");
        names__.push_back("k");
        names__.push_back("beta");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_record);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_breath_test_1_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> m_raw = in__.vector_constrain(n_record);
        size_t m_raw_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < m_raw_j_1_max__; ++j_1__) {
            vars__.push_back(m_raw(j_1__));
        }
        double mu_m = in__.scalar_lb_constrain(0);
        vars__.push_back(mu_m);
        double sigma_m = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma_m);
        Eigen::Matrix<double, Eigen::Dynamic, 1> k_raw = in__.vector_constrain(n_record);
        size_t k_raw_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < k_raw_j_1_max__; ++j_1__) {
            vars__.push_back(k_raw(j_1__));
        }
        double mu_k = in__.scalar_lb_constrain(0);
        vars__.push_back(mu_k);
        double sigma_k = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma_k);
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta_raw = in__.vector_constrain(n_record);
        size_t beta_raw_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < beta_raw_j_1_max__; ++j_1__) {
            vars__.push_back(beta_raw(j_1__));
        }
        double mu_beta = in__.scalar_lb_constrain(0);
        vars__.push_back(mu_beta);
        double sigma_beta = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma_beta);
        double sigma = in__.scalar_lb_constrain(0);
        vars__.push_back(sigma);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 31;
            validate_non_negative_index("m", "n_record", n_record);
            Eigen::Matrix<double, Eigen::Dynamic, 1> m(n_record);
            stan::math::initialize(m, DUMMY_VAR__);
            stan::math::fill(m, DUMMY_VAR__);
            current_statement_begin__ = 32;
            validate_non_negative_index("k", "n_record", n_record);
            Eigen::Matrix<double, Eigen::Dynamic, 1> k(n_record);
            stan::math::initialize(k, DUMMY_VAR__);
            stan::math::fill(k, DUMMY_VAR__);
            current_statement_begin__ = 33;
            validate_non_negative_index("beta", "n_record", n_record);
            Eigen::Matrix<double, Eigen::Dynamic, 1> beta(n_record);
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 36;
            stan::math::assign(m, add(mu_m, multiply(sigma_m, m_raw)));
            current_statement_begin__ = 37;
            stan::math::assign(k, add(mu_k, multiply(sigma_k, k_raw)));
            current_statement_begin__ = 38;
            stan::math::assign(beta, add(mu_beta, multiply(sigma_beta, beta_raw)));
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 31;
            check_greater_or_equal(function__, "m", m, 0);
            current_statement_begin__ = 32;
            check_greater_or_equal(function__, "k", k, 0);
            current_statement_begin__ = 33;
            check_greater_or_equal(function__, "beta", beta, 0);
            // write transformed parameters
            if (include_tparams__) {
                size_t m_j_1_max__ = n_record;
                for (size_t j_1__ = 0; j_1__ < m_j_1_max__; ++j_1__) {
                    vars__.push_back(m(j_1__));
                }
                size_t k_j_1_max__ = n_record;
                for (size_t j_1__ = 0; j_1__ < k_j_1_max__; ++j_1__) {
                    vars__.push_back(k(j_1__));
                }
                size_t beta_j_1_max__ = n_record;
                for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                    vars__.push_back(beta(j_1__));
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_breath_test_1";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t m_raw_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < m_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "m_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_m";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_m";
        param_names__.push_back(param_name_stream__.str());
        size_t k_raw_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < k_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_k";
        param_names__.push_back(param_name_stream__.str());
        size_t beta_raw_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < beta_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t m_j_1_max__ = n_record;
            for (size_t j_1__ = 0; j_1__ < m_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "m" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t k_j_1_max__ = n_record;
            for (size_t j_1__ = 0; j_1__ < k_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "k" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t beta_j_1_max__ = n_record;
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t m_raw_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < m_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "m_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_m";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_m";
        param_names__.push_back(param_name_stream__.str());
        size_t k_raw_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < k_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "k_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_k";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_k";
        param_names__.push_back(param_name_stream__.str());
        size_t beta_raw_j_1_max__ = n_record;
        for (size_t j_1__ = 0; j_1__ < beta_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma_beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t m_j_1_max__ = n_record;
            for (size_t j_1__ = 0; j_1__ < m_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "m" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t k_j_1_max__ = n_record;
            for (size_t j_1__ = 0; j_1__ < k_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "k" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t beta_j_1_max__ = n_record;
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_breath_test_1_namespace::model_breath_test_1 stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
