% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkKey.R
\name{checkKey}
\alias{checkKey}
\title{Check the Brickset API key.}
\usage{
checkKey(key = getOption("brickset_key"))
}
\arguments{
\item{key}{the Brickset API key}
}
\value{
TRUE if the API key is valid.
}
\description{
You can request an API key on the Brickset website here:
https://brickset.com/tools/webservices/requestkey/
}
\details{
The API key can be passed as function parameter or may be set globally using:

\code{options(brickset_key = YOUR_API_KEY)}

Brickset API documentation is available here:
https://brickset.com/article/52664/api-version-3-documentation
}
\examples{
\dontrun{
options(brickset_key = 'BRICKSET_KEY',
        brickset_username = 'BRICKSET_UERNAME',
        brickset_password = 'BRICKSET_PASSWORD')
checkKey() # Will return TRUE if the credentials are correct
}
}
