% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bridgeHand.R
\name{bridgeHand}
\alias{bridgeHand}
\title{bridgeHand}
\usage{
bridgeHand(
  handNumber = "auto",
  seat = FALSE,
  createGraphic = TRUE,
  LTC = "original",
  ...
)
}
\arguments{
\item{handNumber}{An integer for generating a hand, or "auto" to use a random number generator}

\item{seat}{If not false, makes the specified seat South and dealer, so all bidding starts with South and the specified hand type}

\item{createGraphic}{Whether the graphic should be created}

\item{LTC}{Whether to include losing trick count - FALSE for none, "original" or "new" for schema}

\item{...}{Other parameters used in  hand evaluation}
}
\value{
List: Hand ID, Dealer, Hand graphic, Hand points, Hand shape, vulnerability
}
\description{
Generate a bridge hand
}
\note{
To change the hand evaluation pass high card values (HCValues) and shape values (shapeValues) in the arguments.

  HCValues is a string of five digits specifying the value of the Ace, King, Queen, Jack and 10.
  The default is the Milton Work scale of 4, 3, 2, 1, 0.
  shapeValues is a string of eight digits specifying the value of a suit with no cards/"Void", 1-card/"Singleton", ... 7-cards.
  The default is c(3, 2, 1, 0, 0, 1, 2, 3)
  Losing Trick Count (LTCSchema) 'Original' or 'New' as described at https://en.wikipedia.org/wiki/Losing-Trick_Count.
  This assumes a fit will be found.  It is currently not implemented.
}
\examples{
\dontrun{
# Produce a bridge hand
hand <- bridgeHand()

# Produce a bridge hand '500' ensuring South as dealer
hand500 <- bridgeHand(handNumber = 500, seat = "S") # Seat can be any compass point
}
}
