% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brif.R
\name{brifTree.default}
\alias{brifTree.default}
\title{Build a single brif tree taking a data frame as input}
\usage{
\method{brifTree}{default}(
  x,
  depth = 3,
  n_cuts = 2047,
  max_integer_classes = 20,
  max_factor_levels = 30,
  seed = 0,
  ...
)
}
\arguments{
\item{x}{a data frame containing the training data. The first column is treated as the target variable.}

\item{depth}{a positive integer indicating the desired depth of the tree.}

\item{n_cuts}{a positive integer indicating the maximum number of split points to generate on each numeric or integer variable. A large value is preferred for a single tree.}

\item{max_integer_classes}{a positive integer. See \code{\link[brif]{brif.default}} for details.}

\item{max_factor_levels}{a positive integer. See \code{\link[brif]{brif.default}} for details.}

\item{seed}{a non-negative positive integer specifying the random number generator seed.}

\item{...}{other relevant arguments.}
}
\value{
an object of class \code{brif}. See \code{\link{brif.default}} for details.
}
\description{
This function invokes \code{\link[brif]{brif.default}} with appropriately set parameters to generate a single tree with the maximum expected predictive accuracy.
}
