% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getProbScalarRD.R
\name{getProbScalarRD}
\alias{getProbScalarRD}
\title{Calculate risks from arctanh RD and log OP}
\usage{
getProbScalarRD(atanhrd, logop)
}
\arguments{
\item{atanhrd}{arctanh of risk difference}

\item{logop}{log of odds product}
}
\value{
a vector \eqn{(P(y=1|x=0),P(y=1|x=1))}
}
\description{
Calculate risks from arctanh RD and log OP
}
\details{
The \eqn{log OP} is defined as \eqn{log OP = log[(P(y=1|x=0)/P(y=0|x=0))*(P(y=1|x=1)/P(y=0|x=1))]}. 
The inverse hyperbolic tangent function \code{arctanh} is defined as \eqn{arctanh(z) = [log(1+z) - log(1-z)] / 2}.
}
\examples{
getProbScalarRD(0,0)

set.seed(0)
logrr = rnorm(10,0,1)
logop = rnorm(10,0,1)
probs = mapply(getProbScalarRD, logrr, logop)
rownames(probs) = c("P(y=1|x=0)","P(y=1|x=1)")
probs

}

