% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R, R/generics.R
\name{pp_mixture.brmsfit}
\alias{pp_mixture.brmsfit}
\alias{pp_mixture}
\title{Posterior Probabilities of Mixture Component Memberships}
\usage{
\method{pp_mixture}{brmsfit}(x, newdata = NULL, re_formula = NULL,
  allow_new_levels = FALSE, sample_new_levels = "uncertainty",
  incl_autocor = TRUE, subset = NULL, nsamples = NULL, nug = NULL,
  summary = TRUE, robust = FALSE, probs = c(0.025, 0.975), log = FALSE,
  ...)

pp_mixture(x, ...)
}
\arguments{
\item{x}{An \R object usually of class \code{brmsfit}.}

\item{newdata}{An optional data.frame for which to evaluate predictions.
If \code{NULL} (default), the orginal data of the model is used.}

\item{re_formula}{formula containing group-level effects 
to be considered in the prediction. 
If \code{NULL} (default), include all group-level effects; 
if \code{NA}, include no group-level effects.}

\item{allow_new_levels}{A flag indicating if new
levels of group-level effects are allowed 
(defaults to \code{FALSE}). 
Only relevant if \code{newdata} is provided.}

\item{sample_new_levels}{Indicates how to sample new levels 
for grouping factors specified in \code{re_formula}.
This argument is only relevant if \code{newdata} is provided and 
\code{allow_new_levels} is set to \code{TRUE}.
If \code{"uncertainty"} (default), include group-level uncertainty
in the predictions based on the variation of the existing levels. 
If \code{"gaussian"}, sample new levels from the (multivariate) 
normal distribution implied by the group-level standard deviations 
and correlations. This options may be useful for conducting 
Bayesian power analysis. 
If \code{"old_levels"}, directly sample new levels from the
existing levels.}

\item{incl_autocor}{A flag indicating if ARMA autocorrelation
parameters should be included in the predictions. Defaults to 
\code{TRUE}. Setting it to \code{FALSE} will not affect other 
correlation structures such as \code{\link[brms:cor_bsts]{cor_bsts}},
or \code{\link[brms:cor_fixed]{cor_fixed}}.}

\item{subset}{A numeric vector specifying
the posterior samples to be used. 
If \code{NULL} (the default), all samples are used.}

\item{nsamples}{Positive integer indicating how many 
posterior samples should be used. 
If \code{NULL} (the default) all samples are used.
Ignored if \code{subset} is not \code{NULL}.}

\item{nug}{Small positive number for Gaussian process terms only. 
For numerical reasons, the covariance matrix of a Gaussian 
process might not be positive definite. Adding a very small 
number to the matrix's diagonal often solves this problem. 
If \code{NULL} (the default), \code{nug} is chosen internally.}

\item{summary}{Should summary statistics 
 (i.e. means, sds, and 95\% intervals) be returned
instead of the raw values? Default is \code{TRUE}.}

\item{robust}{If \code{FALSE} (the default) the mean is used as 
the measure of central tendency and the standard deviation as 
the measure of variability. If \code{TRUE}, the median and the 
median absolute deivation (MAD) are applied instead.
Only used if \code{summary} is \code{TRUE}.}

\item{probs}{The percentiles to be computed by the \code{quantile} 
function. Only used if \code{summary} is \code{TRUE}.}

\item{log}{Logical; Indicates whether to return 
probabilities on the log-scale.}

\item{...}{Currently ignored.}
}
\value{
If \code{summary = TRUE}, an N x E x K array,
where N is the number of observations, K is the number
of mixture components, and E is equal to \code{length(probs) + 2}.
If \code{summary = FALSE}, an S x N x K arrary, where
S is the number of posterior samples.
}
\description{
Compute the posterior probabilities of mixture component 
memberships for each observation including uncertainty
estimates.
}
\details{
The returned probabilities can be written as
\eqn{P(Kn = k | Yn)}, that is the posterior probability 
that observation n orginiates from component k. 
They are computed using Bayes' Theorem
\deqn{P(Kn = k | Yn) = P(Yn | Kn = k) P(Kn = k) / P(Yn),}
where \eqn{P(Yn | Kn = k)} is the (posterior) likelihood
of observation n for component k, \eqn{P(Kn = k)} is 
the (posterior) mixing probability of component k 
(i.e. parameter \code{theta<k>}), and 
\deqn{P(Yn) = \sum (k=1,...,K) P(Yn | Kn = k) P(Kn = k)}
is a normalizing constant.
}
\examples{
\dontrun{
## simulate some data
set.seed(1234)
dat <- data.frame(
  y = c(rnorm(100), rnorm(50, 2)), 
  x = rnorm(150)
)
## fit a simple normal mixture model
mix <- mixture(gaussian, nmix = 2)
prior <- c(
  prior(normal(0, 5), Intercept, nlpar = mu1),
  prior(normal(0, 5), Intercept, nlpar = mu2),
  prior(dirichlet(2, 2), theta)
)
fit1 <- brm(bf(y ~ x), dat, family = mix,
            prior = prior, chains = 2, inits = 0)
summary(fit1)
   
## compute the membership probabilities         
ppm <- pp_mixture(fit1)
str(ppm)

## extract point estimates for each observation
head(ppm[, 1, ])

## classify every observation according to 
## the most likely component
apply(ppm[, 1, ], 1, which.max)
}

}
