% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo-helpers.R
\name{add_ic}
\alias{add_ic}
\alias{add_ic.brmsfit}
\alias{add_ic<-}
\title{Add model fit criteria to model objects}
\usage{
add_ic(x, ...)

\method{add_ic}{brmsfit}(x, ic = "loo", model_name = NULL, ...)

add_ic(x, ...) <- value
}
\arguments{
\item{x}{An \R object typically of class \code{brmsfit}.}

\item{...}{Further arguments passed to the underlying 
functions computing the model fit criteria.}

\item{ic, value}{Names of model fit criteria
to compute. Currently supported are \code{"loo"}, 
\code{"waic"}, \code{"kfold"}, \code{"R2"} (R-squared), and 
\code{"marglik"} (log marginal likelihood).}

\item{model_name}{Optional name of the model. If \code{NULL}
(the default) the name is taken from the call to \code{x}.}
}
\value{
An object of the same class as \code{x}, but
  with model fit criteria added for later usage.
  Previously computed criterion objects will be overwritten.
}
\description{
Deprecated alias of \code{\link{add_criterion}}.
}
