% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{pairs.brmsfit}
\alias{pairs.brmsfit}
\title{Create a matrix of output plots from a \code{brmsfit} object}
\usage{
\method{pairs}{brmsfit}(x, pars = NA, variable = NULL, regex = FALSE, fixed = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{brmsfit}}

\item{pars}{Deprecated alias of \code{variable}.
Names of the parameters to plot, as given by a
character vector or a regular expression.}

\item{variable}{Names of the variables (parameters) to plot, as given by a
character vector or a regular expression (if \code{regex = TRUE}). By
default, a hopefully not too large selection of variables is plotted.}

\item{regex}{Logical; Indicates whether \code{variable} should
be treated as regular expressions. Defaults to \code{FALSE}.}

\item{fixed}{(Deprecated) Indicates whether parameter names 
should be matched exactly (\code{TRUE}) or treated as
regular expressions (\code{FALSE}). Default is \code{FALSE}
and only works with argument \code{pars}.}

\item{...}{Further arguments to be passed to 
\code{\link[bayesplot:MCMC-scatterplots]{mcmc_pairs}}.}
}
\description{
A \code{\link[graphics:pairs]{pairs}} 
method that is customized for MCMC output.
}
\details{
For a detailed description see  
  \code{\link[bayesplot:MCMC-scatterplots]{mcmc_pairs}}.
}
\examples{
\dontrun{
fit <- brm(count ~ zAge + zBase * Trt 
           + (1|patient) + (1|visit), 
           data = epilepsy, family = "poisson")  
pairs(fit, variable = variables(fit)[1:3])
pairs(fit, variable = "^sd_", regex = TRUE)
}

}
