% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kfold-helpers.R
\name{kfold_predict}
\alias{kfold_predict}
\title{Predictions of K-Fold Cross-Validation}
\usage{
kfold_predict(x, method = c("predict", "fitted"), resp = NULL, ...)
}
\arguments{
\item{x}{Object of class \code{'kfold'} computed by \code{\link{kfold}}.
For \code{kfold_predict} to work, the fitted model objects need to be
stored in \code{x} via argument \code{save_fits} of \code{\link{kfold}}.}

\item{method}{The method used to make predictions. Either \code{"predict"}
or \code{"fitted"}. See \code{\link{predict.brmsfit}} for details.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{...}{Further arguments passed to \code{\link{extract_draws}}
that control several aspects of data validation and prediction.}
}
\value{
A \code{list} with two slots named \code{'y'} and \code{'yrep'}.
  Slot \code{y} contains the vector of observed responses.
  Slot \code{yrep} contains the matrix of predicted responses,
  with rows being posterior draws and columns being observations.
}
\description{
Compute and evaluate predictions after performing from K-fold 
cross-validation via \code{\link{kfold}}.
}
\examples{
\dontrun{
fit <- brm(count ~ log_Base4_c * Trt + (1|patient),
           data = epilepsy, family = poisson())
            
# perform k-fold cross validation
(kf <- kfold(fit, save_fits = TRUE, chains = 1))

# define a loss function
rmse <- function(y, yrep) {
  yrep_mean <- colMeans(yrep)
  sqrt(mean((yrep_mean - y)^2))
}

# predict responses and evaluate the loss
kfp <- kfold_predict(kf)
rmse(y = kfp$y, yrep = kfp$yrep)
}
  
}
\seealso{
\code{\link{kfold}}
}
