% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet-strata.R
\name{facet_strata}
\alias{facet_strata}
\title{Facet data into groups to facilitate exploration}
\usage{
facet_strata(
  n_strata = 12,
  along = NULL,
  fun = mean,
  nrow = NULL,
  ncol = NULL,
  scales = "fixed",
  shrink = TRUE,
  strip.position = "top"
)
}
\arguments{
\item{n_strata}{number of groups to create}

\item{along}{variable to stratify along. This groups by each \code{key} and then
takes a summary statistic (by default, the mean). It then arranges by the
mean value for each \code{key} and assigns the \code{n_strata} groups.}

\item{fun}{summary function. Default is mean.}

\item{nrow}{Number of rows and columns.}

\item{ncol}{Number of rows and columns.}

\item{scales}{Should scales be fixed (\code{"fixed"}, the default),
free (\code{"free"}), or free in one dimension (\code{"free_x"},
\code{"free_y"})?}

\item{shrink}{If \code{TRUE}, will shrink scales to fit output of
statistics, not raw data. If \code{FALSE}, will be range of raw data
before statistical summary.}

\item{strip.position}{By default, the labels are displayed on the top of
the plot. Using \code{strip.position} it is possible to place the labels on
either of the four sides by setting \code{strip.position = c("top",
  "bottom", "left", "right")}}
}
\value{
a ggplot object
}
\description{
This function requires a \code{tbl_ts} object, which can be created with
\code{tsibble::as_tsibble()}. Under the hood, \code{facet_strata} is powered by
\code{\link[=stratify_keys]{stratify_keys()}}.
}
\examples{
library(ggplot2)
ggplot(heights,
       aes(x = year,
           y = height_cm,
           group = country)) +
  geom_line() +
  facet_strata()
  

ggplot(heights,
       aes(x = year,
           y = height_cm,
           group = country)) +
  geom_line() +
  facet_wrap(~continent)

ggplot(heights,
       aes(x = year,
           y = height_cm,
           group = country)) +
  geom_line() +
  facet_strata(along = year)

\donttest{
library(dplyr)
heights \%>\%
  key_slope(height_cm ~ year) \%>\%
  right_join(heights, ., by = "country") \%>\%
  ggplot(aes(x = year,
             y = height_cm)) +
  geom_line(aes(group = country)) +
  geom_smooth(method = "lm") + 
  facet_strata(along = .slope_year)
}
}
