% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jiggle.R
\name{jiggle}
\alias{jiggle}
\title{Jiggle points horizontally}
\usage{
jiggle(group, y, method = c("fixed", "random"), hnum, vnum)
}
\arguments{
\item{group}{Categorical variable defining group; can be a factor,
character, or numeric vector}

\item{y}{Vector of quantitative responses}

\item{method}{What method to use for horizontal jiggling.}

\item{hnum}{Number of horizontal bins for the jiggling.}

\item{vnum}{Number of vertical bins for the jiggling.}
}
\value{
Numeric vector with amounts to jiggle the points horizontally
}
\description{
Spread points out horizontally so that, in dot plot of quantitative
response in multiple categories, the separate points can be seen.
}
\details{
The \code{"random"} method is similar to
\code{\link[base]{jitter}} but with amount of jiggling proportional
to the number of nearby points. The \code{"fixed"} method is
similar to the
\href{http://www.cbs.dtu.dk/~eklund/beeswarm/}{beeswarm package}
}
\seealso{
\code{\link[base]{jitter}}, \code{\link{dotplot}}
}

