% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pick_more_precise.R
\name{pick_more_precise}
\alias{pick_more_precise}
\title{Pick the more precise value for each element in two related vectors}
\usage{
pick_more_precise(x, y, tol = 0.000001)
}
\arguments{
\item{x}{A numeric vector}

\item{y}{A second numeric vector}

\item{tol}{Tolerance for differences between the values}
}
\value{
A vector of combined values
}
\description{
Align two vectors of numbers by their names and then pick a single
value from each, favoring the more precise one. If the two values
differ by more than round-off error, treat the value as missing.
}
\details{
Okay, this is a bit weird. But suppose you have two columns of
numbers that have been subjected to different quirky rounding
patterns. We align the vectors using their names and then for each
element we pick between the two choices, favoring the more-precise
one. If one is missing, choose the non-missing value. If the two
differ by more than the round-off error, treat it as missing.
}
