% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_identify_variables.R
\name{model_identify_variables}
\alias{model_identify_variables}
\alias{model_identify_variables.default}
\alias{model_identify_variables.lavaan}
\title{Identify for each coefficient of a model the corresponding variable}
\usage{
model_identify_variables(model)

\method{model_identify_variables}{default}(model)

\method{model_identify_variables}{lavaan}(model)
}
\arguments{
\item{model}{a model object}
}
\value{
A tibble with four columns:
\itemize{
\item \code{term}: coefficients of the model
\item \code{variable}: the corresponding variable
\item \code{var_class}: class of the variable (cf. \code{\link[stats:checkMFClasses]{stats::.MFclass()}})
\item \code{var_type}: \code{"continuous"}, \code{"categorical"}, \code{"intercept"}
or \code{"interaction"}
}
}
\description{
It will also identify interaction terms and intercept(s).
}
\examples{
Titanic \%>\%
  dplyr::as_tibble() \%>\%
  dplyr::mutate(Survived = factor(Survived, c("No", "Yes"))) \%>\%
  glm(
    Survived ~ Class + Age * Sex,
    data = ., weights = .$n,
    family = binomial
  ) \%>\%
  model_identify_variables()

iris \%>\%
  lm(
    Sepal.Length ~ poly(Sepal.Width, 2) + Species,
    data = .,
    contrasts = list(Species = contr.sum)
  ) \%>\%
  model_identify_variables()
}
\seealso{
\code{\link[=tidy_identify_variables]{tidy_identify_variables()}}

Other model_helpers: 
\code{\link{model_get_contrasts}()},
\code{\link{model_get_model_frame}()},
\code{\link{model_get_model_matrix}()},
\code{\link{model_get_xlevels}()},
\code{\link{model_list_contrasts}()},
\code{\link{model_list_terms_levels}()},
\code{\link{model_list_variables}()}
}
\concept{model_helpers}
