% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_get_weights.R
\name{model_get_weights}
\alias{model_get_weights}
\alias{model_get_weights.default}
\alias{model_get_weights.svyglm}
\alias{model_get_weights.svrepglm}
\alias{model_get_weights.model_fit}
\title{Get sampling weights used by a model}
\usage{
model_get_weights(model)

\method{model_get_weights}{default}(model)

\method{model_get_weights}{svyglm}(model)

\method{model_get_weights}{svrepglm}(model)

\method{model_get_weights}{model_fit}(model)
}
\arguments{
\item{model}{(a model object, e.g. \code{glm})\cr
A model object.}
}
\description{
This function does not cover \code{lavaan} models (\code{NULL} is returned).
}
\note{
For class \code{svrepglm} objects (GLM on a survey object with replicate weights),
it will return the original sampling weights of the data, not the replicate
weights.
}
\examples{
mod <- lm(Sepal.Length ~ Sepal.Width, iris)
mod |> model_get_weights()

mod <- lm(hp ~ mpg + factor(cyl) + disp:hp, mtcars, weights = mtcars$gear)
mod |> model_get_weights()

mod <- glm(
  response ~ stage * grade + trt,
  gtsummary::trial,
  family = binomial
)
mod |> model_get_weights()

mod <- glm(
  Survived ~ Class * Age + Sex,
  data = Titanic |> as.data.frame(),
  weights = Freq,
  family = binomial
)
mod |> model_get_weights()

d <- dplyr::as_tibble(Titanic) |>
  dplyr::group_by(Class, Sex, Age) |>
  dplyr::summarise(
    n_survived = sum(n * (Survived == "Yes")),
    n_dead = sum(n * (Survived == "No"))
  )
mod <- glm(cbind(n_survived, n_dead) ~ Class * Age + Sex, data = d, family = binomial)
mod |> model_get_weights()
}
\seealso{
Other model_helpers: 
\code{\link{model_compute_terms_contributions}()},
\code{\link{model_get_assign}()},
\code{\link{model_get_coefficients_type}()},
\code{\link{model_get_contrasts}()},
\code{\link{model_get_model}()},
\code{\link{model_get_model_frame}()},
\code{\link{model_get_model_matrix}()},
\code{\link{model_get_n}()},
\code{\link{model_get_nlevels}()},
\code{\link{model_get_offset}()},
\code{\link{model_get_pairwise_contrasts}()},
\code{\link{model_get_response}()},
\code{\link{model_get_response_variable}()},
\code{\link{model_get_terms}()},
\code{\link{model_get_xlevels}()},
\code{\link{model_identify_variables}()},
\code{\link{model_list_contrasts}()},
\code{\link{model_list_higher_order_variables}()},
\code{\link{model_list_terms_levels}()},
\code{\link{model_list_variables}()}
}
\concept{model_helpers}
