% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_package.R
\name{assert_package}
\alias{assert_package}
\alias{.assert_package}
\alias{.get_min_version_required}
\title{Check a package installation status or minimum required version}
\usage{
.assert_package(pkg, fn = NULL, pkg_search = "broom.helpers", boolean = FALSE)

.get_min_version_required(pkg, pkg_search = "broom.helpers")
}
\arguments{
\item{pkg}{Package required}

\item{fn}{Calling function from the user perspective. Used to write
informative error messages.}

\item{pkg_search}{the package the function will search for a minimum
required version from.}

\item{boolean}{logical indicating whether to return a \code{TRUE}/\code{FALSE}, rather
than error when package/package version not available. Default is \code{FALSE},
which will return an error if pkg is not installed.}
}
\value{
logical or error
}
\description{
The function checks whether a package is installed and returns an error
or \code{FALSE} if not available. If a package search is provided, the function
will check whether a minimum version of a package is required.
}
\examples{
.assert_package("broom", boolean = TRUE)

.get_min_version_required("brms")
}
