% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeans_tidiers.R
\name{kmeans_tidiers}
\alias{augment.kmeans}
\alias{glance.kmeans}
\alias{kmeans_tidiers}
\alias{tidy.kmeans}
\title{Tidying methods for kmeans objects}
\usage{
\method{tidy}{kmeans}(x, col.names = paste0("x", 1:ncol(x$centers)), ...)

\method{augment}{kmeans}(x, data, ...)

\method{glance}{kmeans}(x, ...)
}
\arguments{
\item{x}{kmeans object}

\item{col.names}{The names to call each dimension of the data in \code{tidy}.
Defaults to \code{x1, x2...}}

\item{...}{extra arguments, not used}

\item{data}{Original data (required for \code{augment})}
}
\value{
All tidying methods return a \code{data.frame} without rownames.
The structure depends on the method chosen.

\code{tidy} returns one row per cluster, with one column for each
dimension in the data describing the center, followed by
  \item{size}{The size of each cluster}
  \item{withinss}{The within-cluster sum of squares}
  \item{cluster}{A factor describing the cluster from 1:k}

\code{augment} returns the original data with one extra column:
  \item{.cluster}{The cluster assigned by the k-means algorithm}

\code{glance} returns a one-row data.frame with the columns
  \item{totss}{The total sum of squares}
  \item{tot.withinss}{The total within-cluster sum of squares}
  \item{betweenss}{The total between-cluster sum of squares}
  \item{iter}{The numbr of (outer) iterations}
}
\description{
These methods summarize the results of k-means clustering into three
tidy forms. \code{tidy} describes the center and size of each cluster,
\code{augment} adds the cluster assignments to the original data, and
\code{glance} summarizes the total within and between sum of squares
of the clustering.
}
\examples{

library(dplyr)
library(ggplot2)

set.seed(2014)
centers <- data.frame(cluster=factor(1:3), size=c(100, 150, 50),
                      x1=c(5, 0, -3), x2=c(-1, 1, -2))
points <- centers \%>\% group_by(cluster) \%>\%
 do(data.frame(x1=rnorm(.$size[1], .$x1[1]),
               x2=rnorm(.$size[1], .$x2[1])))

k <- kmeans(points \%>\% dplyr::select(x1, x2), 3)
tidy(k)
head(augment(k, points))
glance(k)

ggplot(augment(k, points), aes(x1, x2)) +
    geom_point(aes(color = .cluster)) +
    geom_text(aes(label = cluster), data = tidy(k), size = 10)

}
\seealso{
\code{\link{kmeans}}
}

