% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_generics.R
\name{grouped_tidy}
\alias{grouped_tidy}
\title{Tidy output from grouped analysis of any function that has \code{data}
argument in its function call.}
\usage{
grouped_tidy(data, grouping.vars, ..f, ..., tidy.args = list())
}
\arguments{
\item{data}{Dataframe (or tibble) from which variables are to be taken.}

\item{grouping.vars}{Grouping variables.}

\item{..f}{A function, or function name as a string.}

\item{...}{<\link[rlang:dyn-dots]{dynamic}> Arguments for \code{.fn}.}

\item{tidy.args}{A list of arguments to be used in the relevant \code{S3} method.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with information about model components.
}
\description{
Tidy output from grouped analysis of any function that has \code{data}
argument in its function call.
}
\section{Methods}{


\Sexpr[stage=render,results=rd]{generics:::methods_rd("tidy")}

}

\examples{
set.seed(123)
# to speed up computation, let's use only 50\% of the data

# linear model
broomExtra::grouped_tidy(
  data = dplyr::sample_frac(tbl = ggplot2::diamonds, size = 0.5),
  grouping.vars = c(cut, color),
  formula = price ~ carat - 1,
  ..f = stats::lm,
  na.action = na.omit,
  tidy.args = list(quick = TRUE)
)

# linear mixed effects model
broomExtra::grouped_tidy(
  data = dplyr::sample_frac(tbl = ggplot2::diamonds, size = 0.5),
  grouping.vars = "cut",
  ..f = lme4::lmer,
  formula = price ~ carat + (carat | color) - 1,
  control = lme4::lmerControl(optimizer = "bobyqa"),
  tidy.args = list(conf.int = TRUE, conf.level = 0.99)
)
}
\seealso{
\code{\link{tidy}}
}
