% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpvalavg.R
\name{tpvalavg}
\alias{tpvalavg}
\title{Average of The Student t Distribution}
\usage{
tpvalavg(coefficients, hi, lo = -hi, se, df, n = as.integer(ceiling(abs(hi -
  lo) * 10)), log = FALSE)
}
\arguments{
\item{coefficients}{a vector}

\item{hi}{upper bound of the shift range}

\item{lo}{lower bound of the shift range}

\item{se}{standard error}

\item{df}{degrees of freedom}

\item{n}{the number of bins for interpolation}

\item{log}{the probability is in log-scale}
}
\description{
Average of The Student t Distribution
}
\examples{
x=seq(from=0, to=30, length.out=100)

data=do.call(
  rbind
  , lapply(
    seq_len(10)
    , function(cutoff)
      rbind(
        data.frame(x, pval=tpvalavg(x, hi=1, se=1, df=3), cutoff=cutoff)
        )
    )
  )

ggplot2::qplot(x, log(pval), data=data, color=as.factor(cutoff), 
	linetype=as.factor(cutoff), geom='line')
tpvalavg(1, hi=1, se=1, df=3)
exp(tpvalavg(1, hi=1, se=1, df=3, log=TRUE))
}
\keyword{distribution}
