% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR_stats_04_regress.R
\name{HLM_ICC_rWG}
\alias{HLM_ICC_rWG}
\title{Tidy report of HLM indices: ICC(1), ICC(2), and rWG/rWG(J).}
\usage{
HLM_ICC_rWG(
  data,
  group,
  icc.var,
  rwg.vars = icc.var,
  rwg.levels = 0,
  nsmall = 3
)
}
\arguments{
\item{data}{Data frame.}

\item{group}{Grouping variable.}

\item{icc.var}{Key variable for analysis (usually the dependent variable).}

\item{rwg.vars}{Default is \code{icc.var}. It can be:
\itemize{
  \item A single variable (\emph{single-item} measure), then computing rWG.
  \item Multiple variables (\emph{multi-item} measure), then computing rWG(J), where J = the number of items.
}}

\item{rwg.levels}{As rWG/rWG(J) compares the actual group variance to the expected random variance (i.e., the variance of uniform distribution, \eqn{\sigma_EU^2}),
it is required to specify which type of uniform distribution is.
\itemize{
  \item For \emph{continuous} uniform distribution, \eqn{\sigma_EU^2 = (max - min)^2 / 12}.
  Then \code{rwg.levels} is not useful and will be set to \code{0} (the default).
  \item For \emph{discrete} uniform distribution, \eqn{\sigma_EU^2 = (A^2 - 1) / 12},
  where A is the number of response options (levels).
  Then \code{rwg.levels} should be provided (= A in the above formula).
  For example, if the measure is a 5-point Likert scale, you should set \code{rwg.levels=5}.
}}

\item{nsmall}{Number of decimal places of output. Default is 3.}
}
\value{
Invisibly return a list of results.
}
\description{
Compute ICC(1) (non-independence of data),
ICC(2) (reliability of group means),
and rWG/rWG(J) (within-group agreement for single-item/multi-item measures)
in multilevel analysis (HLM).
}
\details{
\describe{
  \item{* Note for the following formulas}{
  \itemize{
    \item \eqn{\sigma_{u0}^2}: between-group variance (i.e., tau00)
    \item \eqn{\sigma_{e}^2}: within-group variance (i.e., residual variance)
    \item \eqn{n_k}: group size of the k-th group
    \item \eqn{K}: number of groups
    \item \eqn{\sigma^2}: actual group variance of the k-th group
    \item \eqn{\sigma_{MJ}^2}: mean value of actual group variance of the k-th group across all J items
    \item \eqn{\sigma_{EU}^2}: expected random variance (i.e., the variance of uniform distribution)
    \item \eqn{J}: number of items
  }
  }
  \item{\strong{ICC(1) (intra-class correlation, or non-independence of data)}}{
    ICC(1) = var.u0 / (var.u0 + var.e) = \eqn{\sigma_{u0}^2 / (\sigma_{u0}^2 + \sigma_{e}^2)})

    ICC(1) is the ICC we often compute and report in multilevel analysis
    (usually in the Null Model, where only the random intercept of group is included).
    It can be interpreted as either \strong{"the proportion of variance explained by groups"} (i.e., \emph{heterogeneity} between groups)
    or \strong{"the expectation of correlation coefficient between any two observations within any group"} (i.e., \emph{homogeneity} within groups).
  }
  \item{\strong{ICC(2) (reliability of group means)}}{
    ICC(2) = mean(var.u0 / (var.u0 + var.e / n.k)) = \eqn{\Sigma[\sigma_{u0}^2 / (\sigma_{u0}^2 + \sigma_{e}^2 / n_k)] / K}

    ICC(2) is a measure of \strong{"the representativeness of group-level aggregated means for within-group individual values"}
    or \strong{"the degree to which an individual score can be considered a reliable assessment of a group-level construct"}.
  }
  \item{\strong{rWG/rWG(J) (within-group agreement for single-item/multi-item measures)}}{
    rWG = \eqn{1 - \sigma^2 / \sigma_{EU}^2}

    rWG(J) = \eqn{1 - (\sigma_{MJ}^2 / \sigma_{EU}^2) / [J * (1 - \sigma_{MJ}^2 / \sigma_{EU}^2) + \sigma_{MJ}^2 / \sigma_{EU}^2]}

    rWG/rWG(J) is a measure of within-group agreement or consensus. Each group has an rWG/rWG(J).
  }
}
}
\examples{
data=lme4::sleepstudy  # continuous variable
HLM_ICC_rWG(data, group="Subject", icc.var="Reaction")

data=lmerTest::carrots  # 7-point scale
HLM_ICC_rWG(data, group="Consumer", icc.var="Preference",
            rwg.vars="Preference",
            rwg.levels=7)
HLM_ICC_rWG(data, group="Consumer", icc.var="Preference",
            rwg.vars=c("Sweetness", "Bitter", "Crisp"),
            rwg.levels=7)

}
\references{
Bliese, P. D. (2000). Within-group agreement, non-independence, and reliability: Implications for data aggregation and Analysis.
In K. J. Klein & S. W. Kozlowski (Eds.), \emph{Multilevel theory, research, and methods in organizations} (pp. 349-381). San Francisco, CA: Jossey-Bass, Inc.

James, L.R., Demaree, R.G., & Wolf, G. (1984). Estimating within-group interrater reliability with and without response bias. \emph{Journal of Applied Psychology, 69}, 85-98.
}
\seealso{
\href{https://CRAN.R-project.org/package=multilevel}{R package "multilevel"}
}
