% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{bs4Carousel}
\alias{bs4Carousel}
\title{Create a Bootstrap 4 carousel}
\usage{
bs4Carousel(..., id, width = 12)
}
\arguments{
\item{...}{Slot for \link{bs4CarouselItem}.}

\item{id}{Unique carousel id.}

\item{width}{Carousel width. Between 1 and 12.}
}
\description{
Beautiful carousel from AdminLTE3
}
\examples{
if(interactive()){
 library(shiny)
 library(bs4Dash)
 
 shiny::shinyApp(
   ui = bs4DashPage(
     navbar = bs4DashNavbar(),
     sidebar = bs4DashSidebar(),
     controlbar = bs4DashControlbar(),
     footer = bs4DashFooter(),
     title = "test",
     body = bs4DashBody(
      title = "Carousel",
      bs4Carousel(
       id = "mycarousel",
       width = 6,
       bs4CarouselItem(
        active = TRUE,
        src = "http://placehold.it/900x500/39CCCC/ffffff&text=I+Love+Bootstrap"
       ),
       bs4CarouselItem(
        active = FALSE,
        src = "http://placehold.it/900x500/3c8dbc/ffffff&text=I+Love+Bootstrap"
       ),
       bs4CarouselItem(
        active = FALSE,
        src = "http://placehold.it/900x500/f39c12/ffffff&text=I+Love+Bootstrap"
       )
     )
    )
   ),
   server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
