% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cards.R
\name{bs4Box}
\alias{bs4Box}
\title{AdminLTE3 simple box}
\usage{
bs4Box(..., title = NULL, width = 6, height = NULL)
}
\arguments{
\item{...}{Body content.}

\item{title}{Box title.}

\item{width}{The width of the box, using the Bootstrap grid system.}

\item{height}{The height of a box, in pixels or other CSS unit. By default
the height scales automatically with the content.}
}
\description{
Create nice and epurated box
}
\examples{
if(interactive()){
 library(shiny)
 library(bs4Dash)
 
 shiny::shinyApp(
   ui = bs4DashPage(
     navbar = bs4DashNavbar(),
     sidebar = bs4DashSidebar(
      bs4SidebarMenu(
       bs4SidebarHeader("Main content"),
       bs4SidebarMenuItem(
         "Basic boxes",
         tabName = "boxes",
         icon = "desktop"
       )
      )
     ),
     controlbar = bs4DashControlbar(),
     footer = bs4DashFooter(),
     title = "test",
     body = bs4DashBody(
      bs4TabItems(
       bs4TabItem(
         tabName = "boxes",
         fluidRow(
          bs4Box(
           height = "600px",
           title = "Box 1",
           plotOutput("plot"),
           column(
            width = 12,
            align = "center",
            sliderInput(
              "obs",
              "Number of observations:",
              min = 0, max = 1000,
              value = 500
            )
           )
          ),
          bs4Box(
           height = "600px",
           title = "Box 2",
           plotOutput("distPlot"),
           column(
            width = 12,
            align = "center",
            radioButtons(
              "dist", 
              inline = TRUE,
              "Distribution type:",
              c("Norm" = "norm",
                "Unif" = "unif",
                "LogNorm" = "lnorm",
                "Exp" = "exp")
            )
           )
          )
         )
       )
      )
     )
   ),
   server = function(input, output) {
    output$plot <- renderPlot({
     hist(rnorm(input$obs))
     })
     
     output$distPlot <- renderPlot({
       dist <- switch(
       input$dist,
       norm = rnorm,
       unif = runif,
       lnorm = rlnorm,
       exp = rexp,
       rnorm
     )
       
       hist(dist(500))
     })
   }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
