% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dashboardPage.R, R/aliases.R
\name{bs4DashPage}
\alias{bs4DashPage}
\alias{dashboardPage}
\title{Create a Boostrap 4 dashboard page}
\usage{
bs4DashPage(
  navbar = NULL,
  sidebar = NULL,
  body = NULL,
  controlbar = NULL,
  footer = NULL,
  title = NULL,
  old_school = FALSE,
  sidebar_mini = TRUE,
  sidebar_collapsed = FALSE,
  controlbar_collapsed = TRUE,
  controlbar_overlay = TRUE,
  enable_preloader = FALSE,
  loading_duration = 2,
  loading_background = "#1E90FF"
)

dashboardPage(
  navbar = NULL,
  sidebar = NULL,
  body = NULL,
  controlbar = NULL,
  footer = NULL,
  title = NULL,
  old_school = FALSE,
  sidebar_mini = TRUE,
  sidebar_collapsed = FALSE,
  controlbar_collapsed = TRUE,
  controlbar_overlay = TRUE,
  enable_preloader = FALSE,
  loading_duration = 2,
  loading_background = "#1E90FF"
)
}
\arguments{
\item{navbar}{Slot for \link{bs4DashNavbar}.}

\item{sidebar}{Slot for \link{bs4DashSidebar}.}

\item{body}{Slot for \link{bs4DashBody}.}

\item{controlbar}{Slot for \link{bs4DashControlbar} (right side).}

\item{footer}{Slot for \link{bs4DashFooter}.}

\item{title}{App title.}

\item{old_school}{Whether to use the wonderful sketchy design for Bootstrap 4. FALSE
by default.}

\item{sidebar_mini}{Whether to see sidebar icons when \link{bs4DashSidebar}.
is collapsed. TRUE by default.}

\item{sidebar_collapsed}{Whether the sidebar is collapsed of not at start. FALSE by default.}

\item{controlbar_collapsed}{Whether the sidebar is collapsed of not at start. TRUE by default.}

\item{controlbar_overlay}{Whether the sidebar covers the content when expanded.
Default to TRUE.}

\item{enable_preloader}{Whether to enable a page loader. FALSE by default.}

\item{loading_duration}{Loader duration in seconds. 2s by default.}

\item{loading_background}{Background color during page startup. Blue by default: 
\url{https://www.w3schools.com/cssref/css_colors.asp}.}
}
\description{
Build an adminLTE3 dashboard page
}
\examples{
if(interactive()){
 library(shiny)
 library(bs4Dash)

 shiny::shinyApp(
   ui = bs4DashPage(
    enable_preloader = TRUE,
    navbar = bs4DashNavbar(),
    sidebar = bs4DashSidebar(),
    controlbar = bs4DashControlbar(),
    footer = bs4DashFooter(),
    title = "test",
    body = bs4DashBody()
   ),
   server = function(input, output) {}
 )
}

if(interactive()){
 library(shiny)
 library(bs4Dash)

 shiny::shinyApp(
   ui = dashboardPage(
   navbar = dashboardHeader(),
   sidebar = dashboardSidebar(),
   body = dashboardBody(
     fluidRow(
       column(width = 4, plotOutput("distPlot")),
       column(width = 4, tableOutput("data")),
       column(width = 4, textOutput("result"))
     )
   ),
   controlbar = dashboardControlbar(
     skin = "light",
     tabsetPanel(
       type = "tabs",
       id = "tabsetpanel",
       tabPanel(
         title = "Tab 1",
         br(),
         sliderInput(
           "obs",
           "Number of observations:",
           min = 0,
           max = 1000,
           value = 500
         )
       ),
       tabPanel(
         title = "Tab 2",
         br(),
         checkboxGroupInput(
           "variable",
           "Variables to show:",
           c("Cylinders" = "cyl",
             "Transmission" = "am",
             "Gears" = "gear")
         )
       ),
       tabPanel(
         title = "Tab 3",
         br(),
         selectInput(
           "state",
           "Choose a state:",
           list(`East Coast` = list("NY", "NJ", "CT"),
                `West Coast` = list("WA", "OR", "CA"),
                `Midwest` = list("MN", "WI", "IA")
           )
         )
       )
     )
    )
   ),
   server = function(input, output) {
    output$distPlot <- renderPlot({
     hist(rnorm(input$obs))
    })
   
    output$data <- renderTable({
      head(mtcars[, c("mpg", input$variable), drop = FALSE])
    }, rownames = TRUE)
   
    output$result <- renderText({
      paste("You chose", input$state)
    })
   }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
