% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R, R/cards.R, R/aliases.R
\name{descriptionBlock}
\alias{descriptionBlock}
\alias{cardPad}
\alias{bs4Card}
\alias{updatebs4Card}
\alias{box}
\alias{updateCard}
\alias{updateBox}
\alias{boxPad}
\title{AdminLTE3 description block}
\usage{
descriptionBlock(
  number = NULL,
  numberColor = NULL,
  numberIcon = NULL,
  header = NULL,
  text = NULL,
  rightBorder = TRUE,
  marginBottom = FALSE
)

cardPad(..., color = NULL, style = NULL)

bs4Card(
  ...,
  title = NULL,
  footer = NULL,
  status = NULL,
  solidHeader = FALSE,
  background = NULL,
  width = 6,
  height = NULL,
  collapsible = TRUE,
  collapsed = FALSE,
  closable = FALSE,
  maximizable = FALSE,
  icon = NULL,
  gradient = FALSE,
  boxToolSize = "sm",
  elevation = NULL,
  headerBorder = TRUE,
  label = NULL,
  dropdownMenu = NULL,
  sidebar = NULL,
  id = NULL
)

updatebs4Card(
  id,
  action = c("remove", "toggle", "toggleMaximize", "restore", "update"),
  options = NULL,
  session = shiny::getDefaultReactiveDomain()
)

box(
  ...,
  title = NULL,
  footer = NULL,
  status = NULL,
  solidHeader = FALSE,
  background = NULL,
  width = 6,
  height = NULL,
  collapsible = TRUE,
  collapsed = FALSE,
  closable = FALSE,
  maximizable = FALSE,
  icon = NULL,
  gradient = FALSE,
  boxToolSize = "sm",
  elevation = NULL,
  headerBorder = TRUE,
  label = NULL,
  dropdownMenu = NULL,
  sidebar = NULL,
  id = NULL
)

updateCard(
  id,
  action = c("remove", "toggle", "toggleMaximize", "restore", "update"),
  options = NULL,
  session = shiny::getDefaultReactiveDomain()
)

updateBox(
  id,
  action = c("remove", "toggle", "toggleMaximize", "restore", "update"),
  options = NULL,
  session = shiny::getDefaultReactiveDomain()
)

boxPad(..., color = NULL, style = NULL)
}
\arguments{
\item{number}{Any number.}

\item{numberColor}{Number color. Valid colors are defined as follows:
\itemize{
  \item \code{primary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#007bff")}.
  \item \code{secondary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6c757d")}.
  \item \code{info}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#17a2b8")}.
  \item \code{success}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#28a745")}.
  \item \code{warning}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ffc107")}.
  \item \code{danger}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#dc3545")}.
  \item \code{gray-dark}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#343a40")}.
  \item \code{gray}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#adb5bd")}.
  \item \code{white}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#fff")}.
  \item \code{indigo}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6610f2")}.
  \item \code{lightblue}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#3c8dbc")}.
  \item \code{navy}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#001f3f")}.
  \item \code{purple}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#605ca8")}.
  \item \code{fuchsia}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#f012be")}.
  \item \code{pink}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#e83e8c")}.
  \item \code{maroon}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#d81b60")}.
  \item \code{orange}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ff851b")}.
  \item \code{lime}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#01ff70")}.
  \item \code{teal}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#39cccc")}.
  \item \code{olive}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#3d9970")}.
}}

\item{numberIcon}{Number icon, if any. Expect \code{\link[shiny]{icon}}.}

\item{header}{Bold text.}

\item{text}{Additional text.}

\item{rightBorder}{TRUE by default. Whether to display a right border to
separate two blocks. The last block on the right should not have a right border.}

\item{marginBottom}{FALSE by default. Set it to TRUE when the
descriptionBlock is used in a \link{boxPad} context.}

\item{...}{Contents of the box.}

\item{color}{Background color. Valid colors are defined as follows:
\itemize{
  \item \code{primary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#007bff")}.
  \item \code{secondary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6c757d")}.
  \item \code{info}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#17a2b8")}.
  \item \code{success}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#28a745")}.
  \item \code{warning}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ffc107")}.
  \item \code{danger}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#dc3545")}.
  \item \code{gray-dark}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#343a40")}.
  \item \code{gray}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#adb5bd")}.
  \item \code{white}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#fff")}.
  \item \code{indigo}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6610f2")}.
  \item \code{lightblue}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#3c8dbc")}.
  \item \code{navy}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#001f3f")}.
  \item \code{purple}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#605ca8")}.
  \item \code{fuchsia}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#f012be")}.
  \item \code{pink}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#e83e8c")}.
  \item \code{maroon}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#d81b60")}.
  \item \code{orange}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ff851b")}.
  \item \code{lime}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#01ff70")}.
  \item \code{teal}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#39cccc")}.
  \item \code{olive}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#3d9970")}.
}}

\item{style}{Custom CSS, if any.}

\item{title}{Optional title.}

\item{footer}{Optional footer text.}

\item{status}{The status of the item. This determines the item's background
  color.  Valid statuses are defined as follows:
\itemize{
  \item \code{primary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#007bff")}.
  \item \code{secondary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6c757d")}.
  \item \code{info}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#17a2b8")}.
  \item \code{success}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#28a745")}.
  \item \code{warning}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ffc107")}.
  \item \code{danger}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#dc3545")}.
  \item \code{gray-dark}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#343a40")}.
  \item \code{gray}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#adb5bd")}.
  \item \code{white}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#fff")}.
  \item \code{indigo}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6610f2")}.
  \item \code{lightblue}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#3c8dbc")}.
  \item \code{navy}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#001f3f")}.
  \item \code{purple}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#605ca8")}.
  \item \code{fuchsia}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#f012be")}.
  \item \code{pink}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#e83e8c")}.
  \item \code{maroon}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#d81b60")}.
  \item \code{orange}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ff851b")}.
  \item \code{lime}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#01ff70")}.
  \item \code{teal}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#39cccc")}.
  \item \code{olive}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#3d9970")}.
}}

\item{solidHeader}{Should the header be shown with a solid color background?}

\item{background}{If NULL (the default), the background of the box will be
  white. Otherwise, a color string. Valid colors are listed in
  \link{validColors}. See below:
\itemize{
 \item \code{primary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#007bff")}.
  \item \code{secondary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6c757d")}.
  \item \code{info}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#17a2b8")}.
  \item \code{success}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#28a745")}.
  \item \code{warning}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ffc107")}.
  \item \code{danger}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#dc3545")}.
  \item \code{gray-dark}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#343a40")}.
  \item \code{gray}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#adb5bd")}.
  \item \code{white}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#fff")}.
  \item \code{indigo}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6610f2")}.
  \item \code{lightblue}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#3c8dbc")}.
  \item \code{navy}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#001f3f")}.
  \item \code{purple}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#605ca8")}.
  \item \code{fuchsia}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#f012be")}.
  \item \code{pink}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#e83e8c")}.
  \item \code{maroon}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#d81b60")}.
  \item \code{orange}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ff851b")}.
  \item \code{lime}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#01ff70")}.
  \item \code{teal}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#39cccc")}.
  \item \code{olive}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#3d9970")}.
}}

\item{width}{The width of the box, using the Bootstrap grid system. This is
used for row-based layouts. The overall width of a region is 12, so the
default card width of 4 occupies 1/3 of that width. For column-based
layouts, use \code{NULL} for the width; the width is set by the column that
contains the box.}

\item{height}{The height of a box, in pixels or other CSS unit. By default
the height scales automatically with the content.}

\item{collapsible}{If TRUE, display a button in the upper right that allows
the user to collapse the box.}

\item{collapsed}{If TRUE, start collapsed. This must be used with
\code{collapsible=TRUE}.}

\item{closable}{If TRUE, display a button in the upper right that allows the user to close the box.}

\item{maximizable}{If TRUE, the card can be displayed in full screen mode.}

\item{icon}{Header icon. Displayed before title. Expect \code{\link[shiny]{icon}}.}

\item{gradient}{Whether to allow gradient effect for the background color. Default to FALSE.}

\item{boxToolSize}{Size of the toolbox: choose among "xs", "sm", "md", "lg".}

\item{elevation}{Card elevation.}

\item{headerBorder}{Whether to display a border between the header and body.
TRUE by default}

\item{label}{Slot for \link{boxLabel}.}

\item{dropdownMenu}{List of items in the boxtool dropdown menu. Use \link{boxDropdown}.}

\item{sidebar}{Slot for \link{boxSidebar}.}

\item{id}{Card id.}

\item{action}{Action to trigger: \code{c("remove", "toggle", "toggleMaximize", "restore", "update")}.}

\item{options}{If action is update, a list of new options to configure the box, such as
\code{list(title = "new title", status = NULL, solidHeader = FALSE,
background = "red", width = 6, height = "200px", collapsible = FALSE, closable = FALSE)}.}

\item{session}{Shiny session.}
}
\description{
\link{descriptionBlock} creates a description block, perfect for writing statistics 
to insert in a \link{box}.

\link{boxPad} creates a vertical container for \link{descriptionBlock}.
It has to be included in a \link{box}.

Build an adminLTE3 card

To update \link{box} on the server side.
}
\examples{
# Box with descriptionBlock
if (interactive()) {
 library(shiny)
 library(bs4Dash)
 
 shinyApp(
  ui = dashboardPage(
    dashboardHeader(),
    dashboardSidebar(),
    dashboardBody(
     box(
      solidHeader = FALSE,
      title = "Status summary",
      background = NULL,
      width = 4,
      status = "danger",
      footer = fluidRow(
        column(
          width = 6,
          descriptionBlock(
            number = "17\%", 
            numberColor = "pink", 
            numberIcon = icon("caret-up"),
            header = "$35,210.43", 
            text = "TOTAL REVENUE", 
            rightBorder = TRUE,
            marginBottom = FALSE
          )
        ),
        column(
          width = 6,
          descriptionBlock(
            number = "18\%", 
            numberColor = "secondary", 
            numberIcon = icon("caret-down"),
            header = "1200", 
            text = "GOAL COMPLETION", 
            rightBorder = FALSE,
            marginBottom = FALSE
          )
        )
      )
     )
    ),
    title = "Description Blocks"
  ),
  server = function(input, output) { }
 )
}

if (interactive()) {
 library(shiny)
 library(bs4Dash)
 
 shinyApp(
  ui = dashboardPage(
    dashboardHeader(),
    dashboardSidebar(),
    dashboardBody(
     box(
      title = "Box with right pad",
      status = "warning",
      fluidRow(
        column(width = 6),
        column(
          width = 6,
          boxPad(
            color = "purple",
            descriptionBlock(
              header = "8390", 
              text = "VISITS", 
              rightBorder = FALSE,
              marginBottom = TRUE
            ),
            descriptionBlock(
              header = "30\%", 
              text = "REFERRALS", 
              rightBorder = FALSE,
              marginBottom = TRUE
            ),
            descriptionBlock(
              header = "70\%", 
              text = "ORGANIC", 
              rightBorder = FALSE,
              marginBottom = FALSE
            )
          )
        )
      )
     )
    ),
    title = "boxPad"
  ),
  server = function(input, output) { }
 )
}

# A box with label, sidebar, dropdown menu
if (interactive()) {
  library(shiny)
  library(bs4Dash)

  shinyApp(
    ui = dashboardPage(
      dashboardHeader(),
      dashboardSidebar(),
      dashboardBody(
        box(
          title = "Closable Box with dropdown",
          closable = TRUE,
          width = 12,
          status = "warning",
          solidHeader = FALSE,
          collapsible = TRUE,
          label = boxLabel(
            text = 1,
            status = "danger"
          ),
          dropdownMenu = boxDropdown(
            boxDropdownItem("Link to google", href = "http://www.google.com"),
            boxDropdownItem("item 2", href = "#"),
            dropdownDivider(),
            boxDropdownItem("item 3", href = "#", icon = icon("th"))
          ),
          sidebar = boxSidebar(
            startOpen = TRUE,
            id = "mycardsidebar",
            sliderInput(
              "obs",
              "Number of observations:",
              min = 0,
              max = 1000,
              value = 500
            )
          ),
          plotOutput("distPlot")
        )
      )
    ),
    server = function(input, output) {
      output$distPlot <- renderPlot({
        hist(rnorm(input$obs))
      })
    }
  )
}
# Toggle a box on the client
if (interactive()) {
  library(shiny)
  library(bs4Dash)

  ui <- dashboardPage(
    dashboardHeader(),
    dashboardSidebar(),
    dashboardBody(
      tags$style("body { background-color: ghostwhite}"),
      fluidRow(
        actionButton("toggle_box", "Toggle Box"),
        actionButton("remove_box", "Remove Box", class = "bg-danger"),
        actionButton("restore_box", "Restore Box", class = "bg-success")
      ),
      actionButton("update_box", "Update Box", class = "bg-info"),
      actionButton("update_box2", "Update Box 2", class = "bg-info"),
      br(),
      br(),
      box(
        title = textOutput("box_state"),
        id = "mybox",
        status = "danger",
        background = "maroon",
        solidHeader = TRUE,
        gradient = TRUE,
        collapsible = TRUE,
        closable = TRUE,
        plotOutput("plot")
      )
    )
  )

  server <- function(input, output, session) {
    output$plot <- renderPlot({
      req(!input$mybox$collapsed)
      plot(rnorm(200))
    })

    output$box_state <- renderText({
      state <- if (input$mybox$collapsed) "collapsed" else "uncollapsed"
      paste("My box is", state)
    })

    observeEvent(input$toggle_box, {
      updateBox("mybox", action = "toggle")
    })

    observeEvent(input$remove_box, {
      updateBox("mybox", action = "remove")
    })

    observeEvent(input$restore_box, {
      updateBox("mybox", action = "restore")
    })

    observeEvent(input$mybox$visible, {
      collapsed <- if (input$mybox$collapsed) "collapsed" else "uncollapsed"
      visible <- if (input$mybox$visible) "visible" else "hidden"
      message <- paste("My box is", collapsed, "and", visible)
      showNotification(message, type = "warning", duration = 1)
    })

    observeEvent(input$update_box, {
      updateBox(
        "mybox",
        action = "update",
        options = list(
          title = h2("hello", dashboardBadge(1, color = "primary")),
          status = "warning",
          solidHeader = TRUE,
          width = 12,
          background = NULL,
          height = "900px",
          closable = FALSE
        )
      )
    })

    observeEvent(input$update_box2, {
      updateBox(
        "mybox",
        action = "update",
        options = list(
          status = NULL,
          solidHeader = FALSE,
          width = 4,
          background = "green",
          height = "500px",
          closable = TRUE
        )
      )
    })
  }

  shinyApp(ui, server)
}
}
\seealso{
Other boxWidgets: 
\code{\link{attachmentBlock}()},
\code{\link{bs4CardLabel}()},
\code{\link{bs4CardSidebar}()},
\code{\link{bs4Carousel}()},
\code{\link{bs4SocialCard}()},
\code{\link{bs4Timeline}()},
\code{\link{cardDropdown}()},
\code{\link{cardProfile}()},
\code{\link{userPost}()}

Other boxWidgets: 
\code{\link{attachmentBlock}()},
\code{\link{bs4CardLabel}()},
\code{\link{bs4CardSidebar}()},
\code{\link{bs4Carousel}()},
\code{\link{bs4SocialCard}()},
\code{\link{bs4Timeline}()},
\code{\link{cardDropdown}()},
\code{\link{cardProfile}()},
\code{\link{userPost}()}

Other cards: 
\code{\link{bs4CardLayout}()},
\code{\link{bs4SocialCard}()},
\code{\link{bs4TabCard}()},
\code{\link{bs4UserCard}()},
\code{\link{renderbs4InfoBox}()},
\code{\link{renderbs4ValueBox}()}
}
\author{
David Granjon, \email{dgranjon@ymail.com}

David Granjon, \email{dgranjon@ymail.com}
}
\concept{boxWidgets}
\concept{cards}
