% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feedbacks.R
\name{toast}
\alias{toast}
\title{Create an adminLTE toast}
\usage{
toast(
  title,
  body = NULL,
  subtitle = NULL,
  options = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{title}{Toast title.}

\item{body}{Body content.}

\item{subtitle}{Toast subtitle.}

\item{options}{Toasts options: a list. See \url{https://adminlte.io/docs/3.0/javascript/toasts.html}.}

\item{session}{Shiny session object.}
}
\description{
Builtin AdminLTE3 toasts
}
\examples{
if (interactive()) {
  library(shiny)
  library(bs4Dash)

  shinyApp(
    ui = dashboardPage(
      header = dashboardHeader(),
      sidebar = dashboardSidebar(),
      body = dashboardBody(
        actionButton("sendToast", "Send Toast")
      ),
      controlbar = dashboardControlbar(),
      title = "Toasts"
    ),
    server = function(input, output) {
      observeEvent(input$sendToast, {
        toast(
          title = "My Toast",
          body = h4("I am a toast!"),
          options = list(
            autohide = TRUE,
            icon = "fas fa-home",
            close = FALSE
          )
        )
      })
    }
  )
}
}
