% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R, R/aliases.R
\name{bs4Timeline}
\alias{bs4Timeline}
\alias{bs4TimelineLabel}
\alias{bs4TimelineItem}
\alias{bs4TimelineItemMedia}
\alias{bs4TimelineStart}
\alias{bs4TimelineEnd}
\alias{timelineBlock}
\alias{timelineLabel}
\alias{timelineItem}
\alias{timelineItemMedia}
\alias{timelineStart}
\alias{timelineEnd}
\title{AdminLTE3 timeline block}
\usage{
bs4Timeline(..., reversed = TRUE, width = 6)

bs4TimelineLabel(..., color = NULL)

bs4TimelineItem(
  ...,
  icon = NULL,
  color = NULL,
  time = NULL,
  title = NULL,
  border = TRUE,
  footer = NULL,
  elevation = NULL
)

bs4TimelineItemMedia(image = NULL, height = NULL, width = NULL)

bs4TimelineStart(icon = shiny::icon("clock"), color = NULL)

bs4TimelineEnd(icon = shiny::icon("hourglass-end"), color = NULL)

timelineBlock(..., reversed = TRUE, width = 6)

timelineLabel(..., color = NULL)

timelineItem(
  ...,
  icon = NULL,
  color = NULL,
  time = NULL,
  title = NULL,
  border = TRUE,
  footer = NULL,
  elevation = NULL
)

timelineItemMedia(image = NULL, height = NULL, width = NULL)

timelineStart(icon = shiny::icon("clock"), color = NULL)

timelineEnd(icon = shiny::icon("hourglass-end"), color = NULL)
}
\arguments{
\item{...}{Any element such as \link{timelineItemMedia} ...}

\item{reversed}{Whether the timeline is reversed or not.}

\item{width}{Media width in pixels.}

\item{color}{Item color. Valid colors are defined as follows:
\itemize{
  \item \code{primary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#007bff")}.
  \item \code{secondary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6c757d")}.
  \item \code{info}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#17a2b8")}.
  \item \code{success}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#28a745")}.
  \item \code{warning}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ffc107")}.
  \item \code{danger}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#dc3545")}.
  \item \code{gray-dark}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#343a40")}.
  \item \code{gray}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#adb5bd")}.
  \item \code{white}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#fff")}.
  \item \code{indigo}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6610f2")}.
  \item \code{lightblue}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#3c8dbc")}.
  \item \code{navy}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#001f3f")}.
  \item \code{purple}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#605ca8")}.
  \item \code{fuchsia}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#f012be")}.
  \item \code{pink}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#e83e8c")}.
  \item \code{maroon}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#d81b60")}.
  \item \code{orange}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ff851b")}.
  \item \code{lime}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#01ff70")}.
  \item \code{teal}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#39cccc")}.
  \item \code{olive}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#3d9970")}.
}}

\item{icon}{Item icon such as "clock", "times", ...}

\item{time}{Item date or time.}

\item{title}{Item title.}

\item{border}{Whether to display a border between the header and the body. TRUE by default.}

\item{footer}{Item footer if any.}

\item{elevation}{Timeline elevation (numeric). NULL by default.}

\item{image}{Media url or path.}

\item{height}{Media height in pixels.}
}
\description{
\link{timelineBlock} creates a timeline block that may be inserted in a \link{box} or outside.

\link{timelineLabel} creates a timeline label element to highlight an event.

\link{timelineItem} creates a timeline item that contains information for a 
given event like the title, description, date, ...

\link{timelineItemMedia} create a specific container for images.

\link{timelineStart} indicates a starting point.

\link{timelineEnd} indicates an end point.
}
\note{
reversed is useful when the user wants to use the timeline
inside a box.
}
\examples{
if(interactive()){
 library(shiny)
 library(bs4Dash)

 shinyApp(
   ui = bs4DashPage(
    header = dashboardHeader(),
    sidebar = dashboardSidebar(),
    controlbar = dashboardControlbar(),
    footer = dashboardFooter(),
    title = "test",
    body = dashboardBody(
     box(
      title = "Timeline",
      timelineBlock(
       width = 12,
       reversed = TRUE,
       timelineEnd(color = "danger"),
       timelineLabel("10 Feb. 2014", color = "pink"),
       timelineItem(
        elevation = 4, 
        title = "Item 1",
        icon = icon("gears"),
        color = "olive",
        time = "now",
        footer = "Here is the footer",
        "This is the body"
       ),
       timelineItem(
        title = "Item 2",
        border = FALSE
       ),
       timelineLabel("3 Jan. 2014", color = "lightblue"),
       timelineItem(
        elevation = 2,
        title = "Item 3",
        icon = icon("paint-brush"),
        status = "orange",
        timelineItemMedia(image = "https://via.placeholder.com/150x100"),
        timelineItemMedia(image = "https://via.placeholder.com/150x100")
       ),
       timelineStart(color = "secondary")
      )
     )
    )
   ),
   server = function(input, output) {}
 )
}

}
\seealso{
Other boxWidgets: 
\code{\link{attachmentBlock}()},
\code{\link{bs4CardLabel}()},
\code{\link{bs4CardSidebar}()},
\code{\link{bs4Carousel}()},
\code{\link{bs4SocialCard}()},
\code{\link{cardDropdown}()},
\code{\link{cardProfile}()},
\code{\link{descriptionBlock}()},
\code{\link{userPost}()}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
\concept{boxWidgets}
