% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record_list_item.R
\name{bs_new_list_item}
\alias{bs_new_list_item}
\title{Add a subject to a list}
\usage{
bs_new_list_item(
  subject,
  uri,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{subject}{Character, length 1. Subject to act on, as a handle or did.}

\item{uri}{Character, length 1. URI of the list to add the subject to.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} of list item information
}
\description{
Add a subject to a list
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/graph/listitem.json}{graph/listitem.json (2024-12-01)}
\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/com/atproto/repo/createRecord.json}{repo/createRecord.json (2023-11-25)}
}

\section{Function introduced}{

\code{v0.2.0} (2024-12-01)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
lst <- bs_new_list(name = 'test list listitem bskyr', purpose = 'curatelist')
bs_new_list_item(subject = 'chriskenny.bsky.social', uri = lst$uri)
# see the list item
bs_get_list(lst$uri)
\dontshow{\}) # examplesIf}
}
\concept{record}
