% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bs-theme-preview.R
\name{bs_theme_preview}
\alias{bs_theme_preview}
\title{Preview the currently set theme}
\usage{
bs_theme_preview(theme = bs_theme(), ..., with_themer = TRUE)
}
\arguments{
\item{theme}{a \code{\link[=bs_theme]{bs_theme()}} object.}

\item{...}{passed along to \code{\link[shiny:runApp]{shiny::runApp()}}.}

\item{with_themer}{whether or not to run the app with \code{\link[=run_with_themer]{run_with_themer()}}.}
}
\value{
nothing, this function is called for its side-effects (launching an
application).
}
\description{
Launches an example shiny app via \code{run_with_themer()} and
\code{bs_theme_dependencies()}. Useful for getting a quick preview of the current
theme setting as well as an interactive GUI for tweaking some of the main
theme settings.
}
\details{
The app that this launches is subject to change.
}
\examples{
theme <- bs_theme(bg = "#6c757d", fg = "white", primary = "orange")
if (interactive()) bs_theme_preview(theme)
}
\seealso{
\code{\link[=run_with_themer]{run_with_themer()}}
}
