% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{ng_bsm}
\alias{ng_bsm}
\title{Non-Gaussian Basic Structural (Time Series) Model}
\usage{
ng_bsm(y, sd_level, sd_slope, sd_seasonal, sd_noise, distribution, phi, u = 1,
  beta, xreg = NULL, period = frequency(y), a1, P1, state_intercept)
}
\arguments{
\item{y}{Vector or a \code{\link{ts}} object of observations.}

\item{sd_level}{A fixed value or a prior for the standard error
of the noise in level equation. See\link[=uniform]{priors} for details.}

\item{sd_slope}{A fixed value or a prior for the standard error
of the noise in slope equation. See\link[=uniform]{priors} for details.
If missing, the slope term is omitted from the model.}

\item{sd_seasonal}{A fixed value or a prior for the standard error
of the noise in seasonal equation. See\link[=uniform]{priors} for details.
If missing, the seasonal component is omitted from the model.}

\item{sd_noise}{Prior for the standard error of the additional noise term.
See\link[=uniform]{priors} for details. If missing, no additional noise term is used.}

\item{distribution}{distribution of the observation. Possible choices are
\code{"poisson"} and \code{"binomial"}.}

\item{phi}{Additional parameter relating to the non-Gaussian distribution.
For Negative binomial distribution this is the dispersion term, and for other
distributions this is ignored.}

\item{u}{Constant parameter for non-Gaussian models. For Poisson and negative binomial distribution, this corresponds to the offset
term. For binomial, this is the number of trials.}

\item{beta}{Prior for the regression coefficients.}

\item{xreg}{Matrix containing covariates.}

\item{period}{Length of the seasonal component i.e. the number of
observations per season. Default is \code{frequency(y)}.}

\item{a1}{Prior means for the initial states (level, slope, seasonals).
Defaults to vector of zeros.}

\item{P1}{Prior covariance for the initial states (level, slope, seasonals).
Default is diagonal matrix with 1e5 on the diagonal.}

\item{state_intercept}{Intercept terms for state equation, given as a
m times n matrix.}
}
\value{
Object of class \code{ng_bsm}.
}
\description{
Constructs a non-Gaussian basic structural model with local level or
local trend component, a seasonal component, and regression component
(or subset of these components).
}
\examples{
model <- ng_bsm(Seatbelts[, "VanKilled"], distribution = "poisson",
  sd_level = halfnormal(0.01, 1),
  sd_seasonal = halfnormal(0.01, 1),
  beta = normal(0, 0, 10),
  xreg = Seatbelts[, "law"])
\dontrun{
set.seed(123)
mcmc_out <- run_mcmc(model, n_iter = 5000, nsim = 10)
mcmc_out$acceptance_rate
theta <- expand_sample(mcmc_out, "theta")
plot(theta)
summary(theta)

library("ggplot2")
ggplot(as.data.frame(theta[,1:2]), aes(x = sd_level, y = sd_seasonal)) +
  geom_point() + stat_density2d(aes(fill = ..level.., alpha = ..level..),
  geom = "polygon") + scale_fill_continuous(low = "green",high = "blue") +
  guides(alpha = "none")

}
}
