% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approx.R
\name{gaussian_approx}
\alias{gaussian_approx}
\alias{gaussian_approx.nongaussian}
\alias{gaussian_approx.ssm_nlg}
\title{Gaussian Approximation of Non-Gaussian/Non-linear State Space Model}
\usage{
gaussian_approx(model, max_iter, conv_tol, ...)

\method{gaussian_approx}{nongaussian}(model, max_iter = 100, conv_tol = 1e-08, ...)

\method{gaussian_approx}{ssm_nlg}(model, max_iter = 100, conv_tol = 1e-08, iekf_iter = 0, ...)
}
\arguments{
\item{model}{Model to be approximated.}

\item{max_iter}{Maximum number of iterations.}

\item{conv_tol}{Tolerance parameter.}

\item{...}{Ignored.}

\item{iekf_iter}{For non-linear models, number of iterations in iterated EKF
(defaults to 0).}
}
\description{
Returns the approximating Gaussian model which has the same conditional 
mode of p(alpha|y, theta) as the original model. 
This function is rarely needed itself, and is mainly available for 
testing and debugging purposes.
}
\examples{
data("poisson_series")
model <- bsm_ng(y = poisson_series, sd_slope = 0.01, sd_level = 0.1,
  distribution = "poisson")
out <- gaussian_approx(model)
}
\references{
Koopman, S.J. and Durbin J. (2012). Time Series Analysis by State Space 
Methods. Second edition. Oxford: Oxford University Press.

Vihola, M, Helske, J, Franks, J. Importance sampling type estimators based 
on approximate marginal Markov chain Monte Carlo. 
Scand J Statist. 2020; 1– 38. https://doi.org/10.1111/sjos.12492
}
