% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bssm-package.R
\docType{data}
\name{negbin_series}
\alias{negbin_series}
\title{Simulated Negative Binomial Time Series Data}
\format{
A time series \code{mts} object with 200 time points and two series.
}
\description{
See example for code for reproducing the data. This was used in
Helske and Vihola (2021).
}
\examples{
# The data was generated as follows:
set.seed(123)
n <- 200
sd_level <- 0.1
drift <- 0.01
beta <- -0.9
phi <- 5

level <- cumsum(c(5, drift + rnorm(n - 1, sd = sd_level)))
x <- 3 + (1:n) * drift + sin(1:n + runif(n, -1, 1))
y <- rnbinom(n, size = phi, mu = exp(beta * x + level))

}
\references{
Helske, J, Vihola, M (2021). bssm: Bayesian Inference of Non-linear and
Non-Gaussian State Space Models in R. R Journal (to appear).
https://arxiv.org/abs/2101.08492
}
\seealso{
\code{negbin_model}
}
\keyword{datasets}
