% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildFunctions.R
\name{bubbleHeatmap}
\alias{bubbleHeatmap}
\title{Generate bubbleHeatmap Plot Object}
\usage{
bubbleHeatmap(
  colorMat,
  sizeMat = colorMat,
  treeName = "Plot",
  context = gpar(cex = 0.8),
  colorSeq = c("#053061", "#2166AC", "#4393C3", "#92C5DE", "#D1E5F0", "#FDDBC7",
    "#F4A582", "#D6604D", "#B2182B", "#67001F"),
  unitBase = unit(0.5, "cm"),
  diameter = 0.8,
  colorLim = c(NA, NA),
  sizeLim = c(NA, NA),
  showTopLabels = TRUE,
  showLeftLabels = TRUE,
  leftLabelsTitle = FALSE,
  showRowBracket = FALSE,
  rowTitle = FALSE,
  showColBracket = FALSE,
  colTitle = FALSE,
  plotTitle = FALSE,
  xTitle = FALSE,
  yTitle = FALSE,
  showColorLegend = TRUE,
  showBubbleLegend = TRUE,
  colorBreaks = NULL,
  sizeBreaks = NULL,
  legendHeight = 8,
  legendTitles = c(expression("-log"[10] * "P"), "Estimate (SD)")
)
}
\arguments{
\item{colorMat, sizeMat}{Numeric matrices containing values to be mapped to
bubble color and size respectively. The dimensions, rownames and colnames of
these matrices must match.}

\item{treeName}{Identifying character string for \code{\link[grid]{gTree}}.}

\item{context}{\code{\link[grid]{gpar}} object to provide drawing context.
Will be applied to the parent viewport in the childrenvp slot of the gTree.}

\item{colorSeq}{Character vector of colors to be used in creating color
scale.}

\item{unitBase}{\code{\link[grid]{unit}} object indicating the size of one
plot grid box.}

\item{diameter}{Maximum diameter of bubbles as multiple of unitBase.}

\item{colorLim, sizeLim}{Numeric vectors indicating limits (min/max) outside
which the values of color/size matrices should be truncated. NOTE! These
data ranges are separate from the scale ranges, which are taken from the
min/max values of \code{colorBreaks} and \code{sizeBreaks}.}

\item{showTopLabels}{Logical, should matrix column names be printed above
plot?}

\item{showLeftLabels}{Logical, should matrix row names be printed above
plot?}

\item{leftLabelsTitle}{Heading to print over the column of row names.}

\item{showRowBracket}{Logical vector, should vertical bracket be printed to
the right of the plot (to label a row of plots in a final figure layout)?}

\item{rowTitle}{Label to be printed to the right of the plot, outside row
bracket if present, to label a row of plots in a final figure layout.}

\item{showColBracket}{Logical, should horizontal bracket be printed
below the plot (to label a column of plots in a final figure layout)?}

\item{colTitle}{Label to be printed below plot, outside col bracket if
present, to label a column of plots in a final figure layout.}

\item{plotTitle}{Plot title string, to be centered above plot.}

\item{xTitle}{X-axis title string, displayed left of \code{LeftLabels}.}

\item{yTitle}{Y-axis title string, displayed above \code{TopLabels}.}

\item{showColorLegend, showBubbleLegend}{Should plot include legends for color
scale/bubble size?}

\item{colorBreaks, sizeBreaks}{Character vectors of legend tick labels. The
min/max values will represent the range of color/size scales. If not supplied
then these will be generated using \code{\link[base]{pretty}}, to a range
outside data values (after values truncated to \code{colorLim}\\\code{sizeLim}
if applicable).}

\item{legendHeight}{Numeric, preferred height of legends in multiples of
\code{unitBase}. This will be supplied to  \code{\link[base]{pretty}}
function. If {sizeBreaks} vector is supplied then this will be ignored and
legend height will be \code{length(sizeBreaks)}.}

\item{legendTitles}{Character vector of legend titles. First string should be
the size legend title, second for the color legend.}
}
\value{
This function creates a bubbleHeatmap using the \code{grid} graphics package.
It does not draw any output but produces a \code{\link[grid]{gTree}} object
which can be drawn using the \code{\link[grid]{grid.draw}} function. Returned
trees always include a \code{\link[grid]{viewport}} object with a 7x6 layout
and a given plot element is always positioned in the same cell, to assist
with aligning elements when combining multiple plots in a single figure (see
vignette, \code{\link{matchLayoutHeights}}, \code{\link{matchLayoutWidths}}).
NOTE: A cairo output device with gradient support is necessary to correctly
render the color legend.
}
\description{
This function creates a gTree for a bubbleHeatmap plot. These plots have a
grid of "bubbles" with the color and size each scaled according to the values
of a different variable. They can be used as an alternative to forest plots
for visualizing estimates and errors that can be organised in a grid format,
correlograms, and any other two variable matrices.
}
\examples{
# Example 1 - Available plot features#
names <- list(paste0("leftLabels", 1:6), paste0("topLabels", 1:10))
colorMat <- matrix(rnorm(60), nrow = 6, ncol = 10, dimnames = names)
sizeMat <- matrix(abs(rnorm(60)), nrow = 6, ncol = 10, dimnames = names)
tree <- bubbleHeatmap(colorMat, sizeMat,
  treeName = "example",
  leftLabelsTitle = "leftLabelsTitle", showRowBracket = TRUE,
  rowTitle = "rowTitle", showColBracket = TRUE, colTitle = "colTitle",
  plotTitle = "plotTitle", xTitle = "xTitle", yTitle = "yTitle",
  legendTitles = c("legendTitles[1]", "legendTitles[2]")
)
grid.draw(tree)

}
\seealso{
Other build functions: 
\code{\link{bubbleHMLegends}()},
\code{\link{bubbleHeatmapList}()},
\code{\link{multiPlotInput}()}
}
\concept{build functions}
