% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildmer.R
\name{buildgamm4}
\alias{buildgamm4}
\title{Use \code{buildmer} to fit generalized additive models using package \code{gamm4}}
\usage{
buildgamm4(
  formula,
  data = NULL,
  family = gaussian(),
  buildmerControl = buildmerControl()
)
}
\arguments{
\item{formula}{See the general documentation under \code{\link{buildmer-package}}}

\item{data}{See the general documentation under \code{\link{buildmer-package}}}

\item{family}{See the general documentation under \code{\link{buildmer-package}}}

\item{buildmerControl}{Control arguments for buildmer --- see the general documentation under \code{\link{buildmerControl}}}
}
\description{
Use \code{buildmer} to fit generalized additive models using package \code{gamm4}
}
\details{
The fixed and random effects are to be passed as a single formula in \emph{\code{lme4} format}. This is internally split up into the appropriate \code{fixed} and \code{random} parts.
}
\examples{
\dontshow{
library(buildmer)
if (requireNamespace('gamm4')) {
model <- buildgamm4(Reaction ~ Days + (Days|Subject),data=lme4::sleepstudy)
}
}
\donttest{
library(buildmer)
if (requireNamespace('gamm4')) model <- buildgamm4(f1 ~ s(timepoint,by=following) +
       s(participant,timepoint,by=following,bs='fs'),data=vowels)
}
}
\seealso{
\code{\link{buildmer-package}}
}
