% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessExpressionMatrix.R
\name{noisyr_counts_with_plot}
\alias{noisyr_counts_with_plot}
\title{Apply a modified noisyR counts pipeline printing a plot}
\usage{
noisyr_counts_with_plot(
  expression.matrix,
  n.elements.per.window = NULL,
  optimise.window.length.logical = FALSE,
  similarity.threshold = 0.25,
  method.chosen = "Boxplot-IQR",
  ...,
  output.plot = FALSE
)
}
\arguments{
\item{expression.matrix}{the expression matrix; rows correspond to genes and
columns correspond to samples}

\item{n.elements.per.window}{number of elements to have in a window passed to
calculate_expression_similarity_counts(); default 10\% of the number of rows}

\item{optimise.window.length.logical}{whether to call optimise_window_length to try and
optimise the value of n.elements.per.window}

\item{similarity.threshold}{parameters passed on to
\code{\link[noisyr]{calculate_noise_threshold}}; they can be single values or vectors;
if they are vectors optimal values are computed by calling
\code{\link[noisyr]{calculate_noise_threshold_method_statistics}} and
minimising the coefficient of variation across samples; all possible values for
method.chosen can be viewed by \code{\link[noisyr]{get_methods_calculate_noise_threshold}}}

\item{method.chosen}{parameters passed on to
\code{\link[noisyr]{calculate_noise_threshold}}; they can be single values or vectors;
if they are vectors optimal values are computed by calling
\code{\link[noisyr]{calculate_noise_threshold_method_statistics}} and
minimising the coefficient of variation across samples; all possible values for
method.chosen can be viewed by \code{\link[noisyr]{get_methods_calculate_noise_threshold}}}

\item{...}{optional arguments passed on to \code{noisyr::noisyr_counts()}}

\item{output.plot}{whether to create an expression-similarity plot for the
noise analysis (printed to the console); default is FALSE}
}
\value{
The denoised expression matrix.
}
\description{
This function is identical to the noisyr::noisyr_counts
function, with the addition of the option to print a line plot of the
similarity against expression for all samples.
}
\examples{
expression.matrix <- as.matrix(read.csv(
  system.file("extdata", "expression_matrix.csv", package = "bulkAnalyseR"), 
  row.names = 1
))[1:500, 1:4]
expression.matrix.denoised <- noisyr_counts_with_plot(expression.matrix)
}
