% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm.R
\name{axe-lm}
\alias{axe-lm}
\alias{axe_call.lm}
\alias{axe_env.lm}
\alias{axe_fitted.lm}
\title{Axing an lm.}
\usage{
\method{axe_call}{lm}(x, verbose = FALSE, ...)

\method{axe_env}{lm}(x, verbose = FALSE, ...)

\method{axe_fitted}{lm}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed lm object.
}
\description{
lm objects are created from the base \pkg{stats} package.
}
\examples{
# Load libraries
suppressWarnings(suppressMessages(library(parsnip)))
suppressWarnings(suppressMessages(library(rsample)))

# Load data
split <- initial_split(mtcars, props = 9/10)
car_train <- training(split)

# Create model and fit
lm_fit <- linear_reg() \%>\%
  set_engine("lm") \%>\%
  fit(mpg ~ ., data = car_train)

out <- butcher(lm_fit, verbose = TRUE)

# Another lm object
wrapped_lm <- function() {
  some_junk_in_environment <- runif(1e6)
  fit <- lm(mpg ~ ., data = mtcars)
  return(fit)
}

# Remove junk
cleaned_lm <- axe_env(wrapped_lm(), verbose = TRUE)

# Check size
lobstr::obj_size(cleaned_lm)

# Compare environment in terms component
lobstr::obj_size(attr(wrapped_lm()$terms, ".Environment"))
lobstr::obj_size(attr(cleaned_lm$terms, ".Environment"))

}
