% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperparam.R, R/print-bvharspec.R
\name{set_sv}
\alias{set_sv}
\alias{print.svspec}
\title{Stochastic Volatility Specification}
\usage{
set_sv(ig_shape = 3, ig_scl = 0.01, initial_mean = 1, initial_prec = 0.1)

\method{print}{svspec}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{ig_shape}{Inverse-Gamma shape of state variance.}

\item{ig_scl}{Inverse-Gamma scale of state variance.}

\item{initial_mean}{Prior mean of initial state.}

\item{initial_prec}{Prior precision of initial state.}

\item{x}{\code{svspec}}

\item{digits}{digit option to print}

\item{...}{not used}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Set SV hyperparameters.
}
\references{
Carriero, A., Chan, J., Clark, T. E., & Marcellino, M. (2022). \emph{Corrigendum to “Large Bayesian vector autoregressions with stochastic volatility and non-conjugate priors” [J. Econometrics 212 (1)(2019) 137–154]}. Journal of Econometrics, 227(2), 506-512.

Chan, J., Koop, G., Poirier, D., & Tobias, J. (2019). \emph{Bayesian Econometric Methods (2nd ed., Econometric Exercises)}. Cambridge: Cambridge University Press.
}
