% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc-models.R
\name{ssvs_bvhar_algo}
\alias{ssvs_bvhar_algo}
\title{Stochastic Search Variable Selection in VHAR}
\description{
This page describes a stochastic search variable selection (SSVS) MCMC algorithm
in a VHAR model.
Recall that \eqn{\Sigma_e = \Psi \Psi^\intercal}.
}
\section{SSVS Prior}{

\subsection{Prior of coefficients}{

Among \eqn{vec(\Phi) = \phi = (\phi_1, \ldots, \phi_{3 k^2 + k})},
non-constant terms are restricted by dummy vector \eqn{\gamma = (\gamma_1, \ldots, \gamma_{3 k^2})^\intercal}.
This defines the diagonal matrix \eqn{D = diag(h_1, \ldots, h_{k^2 p})} by
\deqn{
  h_i = \begin{cases}
    \tau_{0i} & \text{if } \gamma_i = 0 \\
    \tau_{1i} & \text{if } \gamma_i = 1
  \end{cases}
}
with small \eqn{\tau_{0j}} and large \eqn{\tau_{1j}}.

Let \eqn{\phi_{coef}} be the restricted coefficients vector
and let \eqn{\phi_{non}} be the not-restricted coefficients vector, i.e. vectorized constant term.
Each term has its own prior.
\deqn{
  \phi_{coef} \mid \gamma \sim N(\phi_{0, coef}, DD),
  \quad
  \alpha_{non} \sim N(\phi_{0, non}, c I_k)
}
If \eqn{c} is large, then prior influence to \eqn{\phi_{non}} decreases.
By combining each term in appropriate order,
\deqn{\phi \mid \gamma \sim N(0_{3 k^2 + k}, M)}
with
\deqn{
  M = I_{k p + 1} \otimes \begin{bmatrix}
    DD & 0_{k^2 p} \\
    0_{k^2 p}^\intercal & c
  \end{bmatrix}
}
and \eqn{\phi_0} combined in the same way.
}

\subsection{Prior of Other Parameters}{

We are using the the notations for the other parameters, so see \link{ssvs_bvar_algo}.
}
}

\section{Gibbs Sampling}{


Data: \eqn{X_0}, \eqn{Y_0}, VAR linear transformation

Input:
\itemize{
\item VHAR order (week, month)
\item MCMC iteration number
\item Weight of each slab: Bernoulli distribution parameters
\itemize{
\item \eqn{p_j}: of coefficients
\item \eqn{q_{ij}}: of cholesky factor
}
\item Gamma distribution parameters for cholesky factor diagonal elements \eqn{\psi_{jj}}
\itemize{
\item \eqn{a_j}: shape
\item \eqn{b_j}: rate
}
\item Correlation matrix of coefficient vector: \eqn{R = I_{k^2p}}
\item Correlation matrix to restrict cholesky factor (of \eqn{\eta_j}): \eqn{R_j = I_{j - 1}}
\item Tuning parameters for spike-and-slab sd semi-automatic approach
\itemize{
\item \eqn{c_0}: small value (0.1)
\item \eqn{c_1}: large value (10)
}
\item Constant to reduce prior influence on constant term: \eqn{c}
}

Algorithm:
\enumerate{
\item Initialize \eqn{\Psi}, \eqn{\omega}, \eqn{\phi}, \eqn{\gamma}
\item Iterate
\enumerate{
\item Diagonal elements of cholesky factor: \eqn{\psi^{(t)} \mid \phi^{(t - 1)}, \gamma^{(t - 1)}, \omega^{(t - 1)}, Y_0}
\item Off-diagonal elements of cholesky factor: \eqn{\eta^{(t)} \mid \psi^{(t)} \phi^{(t - 1)}, \gamma^{(t - 1)}, \omega^{(t - 1)}, Y_0}
\item Dummy vector for cholesky factor: \eqn{\omega^{(t)} \mid \eta^{(t)}, \psi^{(t)} \phi^{(t - 1)}, \gamma^{(t - 1)}, \omega^{(t - 1)}, Y_0}
\item Coefficient vector: \eqn{\phi^{(t)} \mid \gamma^{(t - 1)}, \Sigma^{(t)}, \omega^{(t)}, Y_0 \sim \mu, \Delta)}
\itemize{
\item where \eqn{\mu = ((\Psi \Psi^\intercal) \otimes (X_1 X_1^\intercal) + M^{-1})^{-1} (( (\Psi \Psi^\intercal) \otimes (X_1 X_1^\intercal) ) \hat{\phi} + M^{-1} \phi_0)}
\item and \eqn{\Delta = ((\Psi \Psi^\intercal) \otimes (X_1 X_1^\intercal) + M^{-1})^{-1}}
}
\item Dummy vector for coefficient vector: \eqn{\gamma^{(t)} \mid \phi^{(t)}, \psi^{(t)}, \eta^{(t)}, \omega^{(t)}, Y_0}
}
}

Output:
\itemize{
\item Parameter trace
\item Update results
\item OLS
}
}

\references{
George, E. I., Sun, D., & Ni, S. (2008). \emph{Bayesian stochastic search for VAR model restrictions. Journal of Econometrics}, 142(1), 553–580.

Koop, G., & Korobilis, D. (2009). \emph{Bayesian Multivariate Time Series Methods for Empirical Macroeconomics}. Foundations and Trends® in Econometrics, 3(4), 267–358.
}
\keyword{internal}
