% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bzinb.R
\name{bzinb}
\alias{bzinb}
\alias{lik.bzinb}
\alias{rbzinb}
\title{The bivariate zero-inflated negative binomial distribution}
\usage{
lik.bzinb(xvec, yvec, a0, a1, a2, b1, b2, p1, p2, p3, p4, param = NULL)

rbzinb(n, a0, a1, a2, b1, b2, p1, p2, p3, p4, param = NULL)

bzinb(xvec, yvec, initial = NULL, tol = 1e-08, maxiter = 50000,
  showFlag = FALSE, vcov = FALSE)
}
\arguments{
\item{xvec, yvec}{a pair of bzinb random vectors. nonnegative integer vectors. 
If not integers, they will be rounded to the nearest integers.}

\item{a0, a1, a2}{shape parameters of the latent gamma variables. They must be positive.}

\item{b1, b2}{scale parameters for the latent gamma variables. They must be positive.}

\item{p1, p2, p3, p4}{proportions summing up to 1 (\code{p1 + p2 + p3 + p4 = 1}). 
\code{p1} is the probability of both latent Poisson variables being observed. 
\code{p2} is the probability of only the first Poisson variables being observed.
\code{p3} is the probability of only the second Poisson variables being observed, and
\code{p4} is the probability of both Poisson variables being dropped out.}

\item{param}{a vector of parameters (\code{(a0, a1, a2, b1, b2, p1, p2, p3, p4)}). 
Either \code{param} or individual parameters (\code{a0, a1, a2, b1, b2, p1, p2, p3, p4}) 
need to be provided.}

\item{n}{number of observations.}

\item{initial}{starting value of param for EM algorithm, a vector of nine values.}

\item{tol}{tolerance for judging convergence. \code{tol = 1e-8} by default.}

\item{maxiter}{maximum number of iterations allowed. \code{tol = 50000} by default.}

\item{showFlag}{if \code{TRUE}, the updated parameter estimates for each iteration 
are printed out. If a positive integer, the updated parameter estimates for 
iterations greater than \code{showFlag} are printed out.}

\item{vcov}{if \code{TRUE}, the variance-covariance matrix and information matrix 
are returned.}
}
\value{
\itemize{
   \item \code{rbzinb} gives a pair of random vectors following BZINB distribution.
   \item \code{bzinb} gives the maximum likelihood estimates of a BZINB pair.
     \itemize{
       \item \code{rho} estimate and standard error of the underlying correlation (\eqn{\rho}) and (\eqn{logit(\rho)})
       \item \code{coefficients} estimate and standard error of the BZINB parameters
       \item \code{lik} log-likelihood of the maximum likelihood estimate
       \item \code{iter} total number of iterations
       \item \code{info} information matrix. Provided when \code{vcov} is \code{TRUE}.
       \item \code{vcov} variance-covariance matrix. Provided when \code{vcov} is \code{TRUE}.
     }
   \item \code{lik.bzinb} gives the log-likelihood of a set of parameters for a BZINB pair.

 }
}
\description{
random generation (\code{rbzinb}), maximum likelihood estimation (\code{bzinb}), 
   and log-likelihood. (\code{lik.bzinb})  for the bivariate zero-inflated negative binomial 
   distribution with parameters equal to \code{(a0, a1, a2, b1, b2, p1, p2, p3, p4)}.
}
\details{
EM theoretically guarantees higher likelihood at each iteration than that of previous iterations. 
See Dempster, Laird, and Rubin (1977). This guarantee comes with an assumption that there is no numerical
error in conditional likelihood maximization at each iteration. Small errors can cause decreasing likelihood 
especially when the iterations reach the point of convergence. Due to this technical error, the EM continues after it reaches
the maximum likelihood point (up to 100 iterations). However, the final estimate being returned is the parameter values at
the maximum likelihood.
}
\examples{
# generating a pair of random vectors
set.seed(2)
data1 <- rbzinb(n = 20, a0 = 1, a1 = 1, a2 = 1, 
                b1 = 1, b2 = 1, p1 = 0.5, p2 = 0.2, 
                p3 = 0.2, p4 = 0.1)

lik.bzinb(xvec = data1[, 1], yvec = data1[ ,2], 
          a0 = 1, a1 = 1, a2 = 1, b1 = 1, b2 = 1, 
          p1 = 0.5, p2 = 0.2, p3 = 0.2, p4 = 0.1)

bzinb(xvec = data1[,1], yvec = data1[,2], showFlag = FALSE)

}
\references{
Cho, H., Preisser, J., Liu, C., and Wu, D. (In preparation), "A bivariate 
 zero-inflated negative binomial model for identifying underlying dependence"

 Dempster, A. P., Laird, N. M., & Rubin, D. B. (1977). Maximum likelihood from 
 incomplete data via the EM algorithm. Journal of the Royal Statistical Society: 
 Series B (Methodological), 39(1), 1-22.
}
\author{
Hunyong Cho, Chuwen Liu, Jinyoung Park, and Di Wu
}
