# c212.interim
# Case 2/12: Interim Analysis wrapper
# R. Carragher
# Date: 28/04/2015


Md1a_lev1 <- new.env()

Md1a_lev1$Id <- "$Id: c212.interim.1a.hier3.lev1.R,v 1.11 2016/10/14 10:39:04 clb13102 Exp clb13102 $"

c212.interim.1a.dep.lev1 <- function(trial.data, sim_type = "SLICE", burnin = 10000, iter = 40000, nchains = 3,
	global.sim.params = data.frame(type = c("MH", "SLICE"), param = c("sigma_MH", "w"), value = c(0.2,1),
	control = c(0,6)),
	sim.params = NULL,
	monitor = data.frame(variable = c("theta", "gamma", "mu.gamma", "mu.theta",
					"sigma2.theta", "sigma2.gamma",
		            "mu.theta.0", "mu.gamma.0", "tau2.theta.0", "tau2.gamma.0"),
					monitor = c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1),
					stringsAsFactors = FALSE),
	initial_values = NULL,
	hyper_params = list(mu.gamma.0.0 = 0, tau2.gamma.0.0 = 10,
	mu.theta.0.0 = 0, tau2.theta.0.0 = 10, alpha.gamma.0.0 = 3, beta.gamma.0.0 = 1, alpha.theta.0.0 = 3,
	beta.theta.0.0 = 1, alpha.gamma = 3, beta.gamma = 1, alpha.theta = 3, beta.theta = 1), memory_model = "HIGH")
{
	interim = M_global$INTERIMdata(Md1a_lev1, trial.data, iter, nchains, burnin, initial_values)

	if (is.null(interim)) {
		return(NULL)
	}

	trial.data = interim$trial.data
	cntrl.data = interim$cntrl.data

	if (M_global$checkBS(Md1a_lev1, cntrl.data)) {
		return(NULL)
	}

	Md1a_lev1$sim_type <- sim_type

	if (nrow(global.sim.params[global.sim.params$type == sim_type,]) != 1) {
		print("Missing simulation parametetrs");
		return(NULL)
	}

	Md1a_lev1$global.sim.param <- global.sim.params[global.sim.params$type == sim_type,]$value
	Md1a_lev1$global.sim.param_ctrl <- global.sim.params[global.sim.params$type == sim_type,]$control

	if (Md1a_lev1$global.sim.param <= 0) {
		print("Invalid simulation parametetr value");
		return(NULL)
	}

	Md1a_lev1$level = 1

	sim.params = M_global$INTERIM_sim_params1a(Md1a_lev1, sim.params, sim_type, trial.data, cntrl.data)

	monitor = M_global$INTERIM_monitor_1a_3(monitor)

	# Initialise the hyper-parameters
	Md1a_lev1$mu.gamma.0.0 <- hyper_params$mu.gamma.0.0
	Md1a_lev1$tau2.gamma.0.0 <- hyper_params$tau2.gamma.0.0
	Md1a_lev1$alpha.gamma <- hyper_params$alpha.gamma
	Md1a_lev1$beta.gamma <- hyper_params$beta.gamma
	Md1a_lev1$alpha.gamma.0.0 <- hyper_params$alpha.gamma.0.0
	Md1a_lev1$beta.gamma.0.0 <- hyper_params$beta.gamma.0.0

	Md1a_lev1$mu.theta.0.0 <- hyper_params$mu.theta.0.0
	Md1a_lev1$tau2.theta.0.0 <- hyper_params$tau2.theta.0.0
	Md1a_lev1$alpha.theta <- hyper_params$alpha.theta
	Md1a_lev1$beta.theta <- hyper_params$beta.theta
	Md1a_lev1$alpha.theta.0.0 <- hyper_params$alpha.theta.0.0
	Md1a_lev1$beta.theta.0.0 <- hyper_params$beta.theta.0.0

	Ret2 = .Call("c2121a_poisson_mc_exec", as.integer(nchains), as.integer(burnin),
					as.integer(iter), Md1a_lev1$sim_type,
					memory_model,
					as.numeric(Md1a_lev1$global.sim.param),
					as.numeric(Md1a_lev1$global.sim.param_ctrl),
					sim.params,
					monitor,
					as.integer(Md1a_lev1$numIntervals), as.integer(Md1a_lev1$level),
					Md1a_lev1$maxBs, as.integer(Md1a_lev1$numB), as.integer(Md1a_lev1$maxAEs),
					as.integer(t(Md1a_lev1$nAE)), as.integer(aperm(Md1a_lev1$x)), as.integer(aperm(Md1a_lev1$y)),
					as.integer(aperm(Md1a_lev1$C)),
					as.integer(aperm(Md1a_lev1$T)),
					as.numeric(aperm(Md1a_lev1$theta)),
					as.numeric(aperm(Md1a_lev1$gamma)),
					as.numeric(Md1a_lev1$mu.gamma.0.0),
					as.numeric(Md1a_lev1$tau2.gamma.0.0),
					as.numeric(Md1a_lev1$mu.theta.0.0),
					as.numeric(Md1a_lev1$tau2.theta.0.0),
					as.numeric(Md1a_lev1$alpha.gamma.0.0),
					as.numeric(Md1a_lev1$beta.gamma.0.0),
					as.numeric(Md1a_lev1$alpha.theta.0.0),
					as.numeric(Md1a_lev1$beta.theta.0.0),
					as.numeric(Md1a_lev1$alpha.gamma),
					as.numeric(Md1a_lev1$beta.gamma),
					as.numeric(Md1a_lev1$alpha.theta),
					as.numeric(Md1a_lev1$beta.theta),
					as.numeric(Md1a_lev1$mu.gamma.0),
					as.numeric(Md1a_lev1$tau2.gamma.0),
					as.numeric(Md1a_lev1$mu.theta.0),
					as.numeric(Md1a_lev1$tau2.theta.0),
					as.numeric(aperm(Md1a_lev1$mu.gamma)),
					as.numeric(aperm(Md1a_lev1$mu.theta)),
					as.numeric(aperm(Md1a_lev1$sigma2.gamma)),
					as.numeric(aperm(Md1a_lev1$sigma2.theta)))

	mu.gamma.0_samples = NULL
	if (monitor[monitor$variable == "mu.gamma.0", ]$monitor == 1) {
		mu.gamma.0_samples <- .Call("getMuGamma0SamplesInterimAll")
		mu.gamma.0_samples = aperm(mu.gamma.0_samples)
	}

	mu.theta.0_samples = NULL
	if (monitor[monitor$variable == "mu.theta.0", ]$monitor == 1) {
		mu.theta.0_samples <- .Call("getMuTheta0SamplesInterimAll")
		mu.theta.0_samples = aperm(mu.theta.0_samples)
	}

	tau2.gamma.0_samples = NULL
	if (monitor[monitor$variable == "tau2.gamma.0", ]$monitor == 1) {
		tau2.gamma.0_samples <- .Call("getTau2Gamma0SamplesInterimAll")
		tau2.gamma.0_samples = aperm(tau2.gamma.0_samples)
	}

	tau2.theta.0_samples = NULL
	if (monitor[monitor$variable == "tau2.theta.0", ]$monitor == 1) {
		tau2.theta.0_samples <- .Call("getTau2Theta0SamplesInterimAll")
		tau2.theta.0_samples = aperm(tau2.theta.0_samples)
	}

	mu.theta_samples = NULL
	if (monitor[monitor$variable == "mu.theta", ]$monitor == 1) {
		mu.theta_samples <- .Call("getMuThetaSamplesInterimAll")
		mu.theta_samples <- aperm(mu.theta_samples)
	}

	mu.gamma_samples = NULL
	if (monitor[monitor$variable == "mu.gamma", ]$monitor == 1) {
		mu.gamma_samples <- .Call("getMuGammaSamplesInterimAll")
		mu.gamma_samples <- aperm(mu.gamma_samples)
	}

	sigma2.theta_samples = NULL
	if (monitor[monitor$variable == "sigma2.theta", ]$monitor == 1) {
		sigma2.theta_samples <- .Call("getSigma2ThetaSamplesInterimAll")
		sigma2.theta_samples <- aperm(sigma2.theta_samples)
	}

	sigma2.gamma_samples = NULL
	if (monitor[monitor$variable == "sigma2.gamma", ]$monitor == 1) {
		sigma2.gamma_samples <- .Call("getSigma2GammaSamplesInterimAll")
		sigma2.gamma_samples <- aperm(sigma2.gamma_samples)
	}

	gamma_samples = NULL
	gamma_acc = NULL
	if (monitor[monitor$variable == "gamma", ]$monitor == 1) {
		gamma_samples = .Call("getGammaSamplesInterimAll")
		gamma_samples = aperm(gamma_samples)

		gamma_acc = .Call("getGammaAcceptInterimAll")
		gamma_acc <- aperm(gamma_acc)
	}

	theta_samples = NULL
	theta_acc = NULL
	if (monitor[monitor$variable == "theta", ]$monitor == 1) {
		theta_samples = .Call("getThetaSamplesInterimAll")
		theta_samples = aperm(theta_samples)

		theta_acc = .Call("getThetaAcceptInterimAll")
		theta_acc <- aperm(theta_acc)
	}

	.C("Release_Interim")

	model_fit = list(id = Md1a_lev1$Id, sim_type = Md1a_lev1$sim_type, chains = nchains, nIntervals = Md1a_lev1$numIntervals,
			Intervals = Md1a_lev1$Intervals, nBodySys = Md1a_lev1$numB, maxBs = Md1a_lev1$maxBs,
			maxAEs = Md1a_lev1$maxAEs, nAE = Md1a_lev1$nAE, AE=Md1a_lev1$AE, B = Md1a_lev1$B,
			burnin = burnin, iter = iter,
			monitor = monitor,
			gamma = gamma_samples,
			theta = theta_samples,
			mu.gamma = mu.gamma_samples,
			mu.theta = mu.theta_samples,
			sigma2.gamma = sigma2.gamma_samples,
			sigma2.theta = sigma2.theta_samples,
			mu.gamma.0 = mu.gamma.0_samples,
			mu.theta.0 = mu.theta.0_samples,
			tau2.gamma.0 = tau2.gamma.0_samples,
			tau2.theta.0 = tau2.theta.0_samples,
			gamma_acc = gamma_acc,
			theta_acc = theta_acc)
			
	# Model is poisson with BB1a hierarchy and independent intervals
	attr(model_fit, "model") = "1a_pois_dep_lev1"

	return(model_fit)
}

Md1a_lev1$initVars = function() {

    # Data Structure
    Md1a_lev1$B <- c()
    Md1a_lev1$numB <- NA
    Md1a_lev1$numIntervals <- NA
    Md1a_lev1$nAE <- c()
    Md1a_lev1$maxAEs <- NA

    # Trial Event Data
    Md1a_lev1$x <- array()
    Md1a_lev1$C <- array()
    Md1a_lev1$y <- array()
    Md1a_lev1$T <- array()

    # Hyperparameters
    Md1a_lev1$mu.gamma.0.0 <- NA
    Md1a_lev1$tau2.gamma.0.0 <- NA
    Md1a_lev1$mu.theta.0.0 <- NA
    Md1a_lev1$tau2.theta.0.0 <- NA
    Md1a_lev1$alpha.gamma.0.0 <- NA
    Md1a_lev1$beta.gamma.0.0 <- NA
    Md1a_lev1$alpha.theta.0.0 <- NA
    Md1a_lev1$beta.theta.0.0 <- NA
    Md1a_lev1$alpha.gamma <- NA
    Md1a_lev1$beta.gamma <- NA
    Md1a_lev1$alpha.theta <- NA
    Md1a_lev1$beta.theta <- NA

	# Parameters/Simulated values
    # Stage 3
    Md1a_lev1$mu.gamma.0 <- c()
    Md1a_lev1$tau2.gamma.0 <- c()
    Md1a_lev1$mu.theta.0 <- c()
    Md1a_lev1$tau2.theta.0 <- c()

    # Stage 2
    Md1a_lev1$mu.gamma <- array()
    Md1a_lev1$mu.theta <- array()
    Md1a_lev1$sigma2.gamma <- array()
    Md1a_lev1$sigma2.theta <- array()

    # Stage 1
    Md1a_lev1$theta <- array()
    Md1a_lev1$gamma <- array()
}

Md1a_lev1$initChains = function(c) {
	# Choose random values for gamma and theta
	for (i in 1:Md1a_lev1$numIntervals) {
		numB = Md1a_lev1$numB[i]
		for (b in 1:numB) {
			Md1a_lev1$gamma[c, i, b, 1:Md1a_lev1$nAE[i, b]] <- runif(Md1a_lev1$nAE[i, b], -10, 10)
			Md1a_lev1$theta[c, i, b, 1:Md1a_lev1$nAE[i, b]] <- runif(Md1a_lev1$nAE[i, b], -10, 10)

			Md1a_lev1$theta[c, i, b, ][is.infinite(Md1a_lev1$theta[c, i, b, ])] = -10
			Md1a_lev1$gamma[c, i, b, ][is.infinite(Md1a_lev1$gamma[c, i, b, ])] = -10

			Md1a_lev1$theta[1, i, b, ][is.nan(Md1a_lev1$theta[1, i, b, ])] = -10 # -1000
			Md1a_lev1$gamma[1, i, b, ][is.nan(Md1a_lev1$gamma[1, i, b, ])] = -10 # -1000
		}



		Md1a_lev1$mu.gamma.0[c] = runif(1, -10, 10)
		Md1a_lev1$tau2.gamma.0[c] = runif(1, 5, 20)
		Md1a_lev1$mu.theta.0[c] = runif(1, -10, 10)
		Md1a_lev1$tau2.theta.0[c] = runif(1, 5, 20)
	}

	Md1a_lev1$mu.theta[c, 1:numB] = runif(numB, -10, 10)
	Md1a_lev1$mu.gamma[c, 1:numB] = runif(numB, -10, 10)
	Md1a_lev1$sigma2.gamma[c, 1:numB] = runif(numB, 5, 20)
	Md1a_lev1$sigma2.theta[c, 1:numB] = runif(numB, 5, 20)
}

Md1a_lev1$initialiseChains = function(initial_values, nchains) {

	Md1a_lev1$theta = array(0, dim=c(nchains, Md1a_lev1$numIntervals, Md1a_lev1$maxBs, Md1a_lev1$maxAEs))
	Md1a_lev1$gamma = array(0, dim=c(nchains, Md1a_lev1$numIntervals, Md1a_lev1$maxBs, Md1a_lev1$maxAEs))

	if (is.null(initial_values)) {

		# Initialise the first chain with the data
		for (i in 1:Md1a_lev1$numIntervals) {
			numB = Md1a_lev1$numB[i]
			for (b in 1:numB) {
				Md1a_lev1$gamma[1, i, b, ] <- log(Md1a_lev1$x[i, b,]/Md1a_lev1$C[i, b, ])
				Md1a_lev1$theta[1, i, b, ] <- log(Md1a_lev1$y[i, b,]/Md1a_lev1$T[i]) - Md1a_lev1$gamma[1, i, b, ]

				Md1a_lev1$theta[1, i, b, ][is.infinite(Md1a_lev1$theta[1, i, b, ])] = -10 # -1000
				Md1a_lev1$gamma[1, i, b, ][is.infinite(Md1a_lev1$gamma[1, i, b, ])] = -10 # -1000

				Md1a_lev1$theta[1, i, b, ][is.nan(Md1a_lev1$theta[1, i, b, ])] = -10 # -1000
				Md1a_lev1$gamma[1, i, b, ][is.nan(Md1a_lev1$gamma[1, i, b, ])] = -10 # -1000
			}
		}

		Md1a_lev1$mu.theta <- array(0, dim = c(nchains, Md1a_lev1$maxBs))
		Md1a_lev1$mu.gamma <- array(0, dim = c(nchains, Md1a_lev1$maxBs))
		Md1a_lev1$sigma2.gamma <- array(10, dim = c(nchains, Md1a_lev1$maxBs))
		Md1a_lev1$sigma2.theta <- array(10, dim = c(nchains, Md1a_lev1$maxBs))

		Md1a_lev1$mu.gamma.0 <- rep(0, nchains)
		Md1a_lev1$tau2.gamma.0 <- rep(10, nchains)
		Md1a_lev1$mu.theta.0 <- rep(0, nchains)
		Md1a_lev1$tau2.theta.0 <- rep(10, nchains)

		if (nchains > 1) {
			for (c in 2:nchains) {
				Md1a_lev1$initChains(c)
			}

		}
	}
	else {

		Md1a_lev1$mu.gamma.0 <- rep(0, nchains)
		Md1a_lev1$tau2.gamma.0 <- rep(10, nchains)
		Md1a_lev1$mu.theta.0 <- rep(0, nchains)
		Md1a_lev1$tau2.theta.0 <- rep(10, nchains)

		for (c in 1:nchains) {
			Md1a_lev1$mu.gamma.0[c] = initial_values$mu.gamma.0[c]
			Md1a_lev1$mu.theta.0[c] = initial_values$mu.theta.0[c]
			Md1a_lev1$tau2.gamma.0[c] = initial_values$tau2.gamma.0[c]
			Md1a_lev1$tau2.theta.0[c] = initial_values$tau2.theta.0[c]
		}

		Md1a_lev1$mu.theta <- array(0, dim = c(nchains, Md1a_lev1$maxBs))

		Md1a_lev1$mu.gamma <- array(0, dim = c(nchains, Md1a_lev1$maxBs))
		Md1a_lev1$sigma2.gamma <- array(0, dim = c(nchains, Md1a_lev1$maxBs))
		Md1a_lev1$sigma2.theta <- array(0, dim = c(nchains, Md1a_lev1$maxBs))

		for (c in 1:nchains) {
			# Have the same 
			for (b in 1:length(Md1a_lev1$B[1,])) {
				data = initial_values$mu.theta[initial_values$mu.theta$chain == c
												& initial_values$mu.theta$B == Md1a_lev1$B[1, b],]
				Md1a_lev1$mu.theta[c, b] = data$value

				data = initial_values$mu.gamma[initial_values$mu.gamma$chain == c
												& initial_values$mu.gamma$B == Md1a_lev1$B[1, b],]
				Md1a_lev1$mu.gamma[c, b] = data$value

				data = initial_values$sigma2.theta[initial_values$sigma2.theta$chain == c
												& initial_values$sigma2.theta$B == Md1a_lev1$B[1, b],]
				Md1a_lev1$sigma2.theta[c, b] = data$value

				data = initial_values$sigma2.gamma[initial_values$sigma2.gamma$chain == c
												& initial_values$sigma2.gamma$B == Md1a_lev1$B[1, b],]
				Md1a_lev1$sigma2.gamma[c, b] = data$value
			}
		}

		for (c in 1:nchains) {
			for (i in 1:Md1a_lev1$numIntervals) {
				interval = Md1a_lev1$Intervals[i]
				for (b in 1:Md1a_lev1$numB[i]) {
					for (j in 1:Md1a_lev1$nAE[i, b]) {
						ae = Md1a_lev1$AE[i, b, j]
						data = initial_values$gamma[initial_values$gamma$chain == c
										& initial_values$gamma$Interval == interval
										& initial_values$gamma$B == Md1a_lev1$B[i, b]
										& initial_values$gamma$AE == ae,]
						Md1a_lev1$gamma[c, i, b, j] = data$value

						data = initial_values$theta[initial_values$theta$chain == c
										& initial_values$theta$Interval == interval
										& initial_values$theta$B == Md1a_lev1$B[i, b]
										& initial_values$theta$AE == ae,]
						Md1a_lev1$theta[c, i, b, j] = data$value
					}
				}
			}
		}
	}
}
