% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\name{rangeCheck}
\alias{rangeCheck}
\title{Check for horizontal and vertical extrapolation}
\usage{
rangeCheck(model, minAge = NULL, maxAge = NULL, minNorm = NULL,
  maxNorm = NULL, digits = 3)
}
\arguments{
\item{model}{The regression model}

\item{minAge}{The lower age bound}

\item{maxAge}{The upper age bound}

\item{minNorm}{The lower norm value bound}

\item{maxNorm}{The upper norm value bound}

\item{digits}{The precision for rounding the norm and age data}
}
\value{
the report
}
\description{
Regression model only work in a specific range and extrapolation horizontally (outside
the original range) or vertically (extreme norm scores) might lead to inconsistent
results. The function generates a message, indicating extrapolation and the range of the original data.
}
\examples{
normData <- prepareData()
m <- bestModel(normData)
print(rangeCheck(m))
}
