% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotPercentiles}
\alias{plotPercentiles}
\title{Plot norm curves against actual percentiles}
\usage{
plotPercentiles(data, model, minRaw = NULL, maxRaw = NULL,
  minAge = NULL, maxAge = NULL, raw = NULL, group = NULL,
  percentiles = c(0.025, 0.1, 0.25, 0.5, 0.75, 0.9, 0.975),
  scale = NULL, type = 7, title = NULL, covariate = NULL)
}
\arguments{
\item{data}{The raw data including the percentiles and norm scores}

\item{model}{The model from the bestModel function}

\item{minRaw}{Lower bound of the raw score (default = 0)}

\item{maxRaw}{Upper bound of the raw score}

\item{minAge}{Variable to restrict the lower bound of the plot to a specific age}

\item{maxAge}{Variable to restrict the upper bound of the plot to a specific age}

\item{raw}{The name of the raw variable}

\item{group}{The name of the grouping variable; the distinct groups are automatically
determined}

\item{percentiles}{Vector with percentile scores, ranging from 0 to 1 (exclusive)}

\item{scale}{The norm scale, either 'T', 'IQ', 'z', 'percentile' or
self defined with a double vector with the mean and standard deviation,
f. e. c(10, 3) for Wechsler scale index points; if NULL, scale information from the
data preparation is used (default)}

\item{type}{The type parameter of the quantile function to estimate the percentiles
of the raw data (default 7)}

\item{title}{custom title for plot}

\item{covariate}{In case, a covariate has been used, please specify the degree of the covariate /
the specific value here. If no covariate is specified, both degrees will be plotted.}
}
\description{
The function plots the norm curves based on the regression model against
the actual percentiles from the raw data. As in 'plotNormCurves',
please check for inconsistent curves, especially intersections.
Violations of this assumption are a strong
indication for problems
in modeling the relationship between raw and norm scores.
In general, extrapolation (point 1 and 2) can carefully be done to a
certain degree outside the original sample, but it should in general
be handled with caution.
The original percentiles are displayed as distinct points in the according
color, the model based projection of percentiles are drawn as lines.
Please note, that the estimation of the percentiles of the raw data is done with
the quantile function with the default settings. Please consult help(quantile)
and change the 'type' parameter accordingly.
}
\examples{
# Load example data set, compute model and plot results
normData <- prepareData()
m <- bestModel(data = normData)
plotPercentiles(normData, m)
}
\seealso{
plotNormCurves, plotPercentileSeries
}
