% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preparation.R
\name{prepareData}
\alias{prepareData}
\title{Prepare data for modelling in one step (convenience method)}
\usage{
prepareData(data = NULL, group = "group", raw = "raw",
  age = "group", width = NA, scale = "T", silent = FALSE)
}
\arguments{
\item{data}{data.frame with a grouping variable named 'group' and a raw score variable
named 'raw'. In case no object is provided, cNORM uses the inbuilt sample data to
demonstrate the procedure.}

\item{group}{grouping variable in the data, e. g. age groups, grades ...
Setting group = FALSE deactivates modelling in dependence of age. Use this in case you do want
conventional norm tables.}

\item{raw}{the raw scores}

\item{age}{the continuous explanatory variable; by default set to "group"}

\item{width}{if a width is provided, the function switches to rankBySlidingWindow to determine the
observed raw scores, otherwise, ranking is done by group (default)}

\item{scale}{type of norm scale, either T (default), IQ, z or percentile (= no
transformation); a double vector with the mean and standard deviation can as well,
be provided f. e. c(10, 3) for Wechsler scale index point}

\item{silent}{set to TRUE to suppress messages}
}
\value{
data frame including the norm scores, powers and interactions of the norm score and
grouping variable
}
\description{
This is a convenience method to either load the inbuilt sample dataset, or
to provide a data frame with the variables "raw" (for the raw scores) and "group"
The function ranks the data within groups, computes norm values, powers of the norm
scores and interactions. Afterwards, you can use these preprocessed data to
determine the best fitting model.
}
\examples{
# conducts ranking and computation of powers and interactions with the 'elfe' dataset
data.elfe <- prepareData()

# variable names can be specified as well, here with the BMI data included in the package
data.bmi <- prepareData(CDC, group = "group", raw = "bmi", age = "age")

# modelling with only one group with the 'elfe' dataset as an example
# this results in conventional norming
data.elfe2 <- prepareData(data = elfe, group = FALSE)
m <- bestModel(data.elfe2)
}
