% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{CDC}
\alias{CDC}
\title{BMI growth curves from age 2 to 25}
\format{
A data frame with 45053 rows and 7 variables:
\describe{
  \item{age}{continuous age in years, based on the month variable}
  \item{group}{age group; chronological age in years at the time of examination}
  \item{month}{chronological age in month at the time of examination}
  \item{sex}{sex of the participant, 1 = male, 2 = female}
  \item{height}{height of the participants in cm}
  \item{weight}{weight of the participants in kg}
  \item{bmi}{the body mass index, computed by (weight in kg)/(height in m)^2}
}

A data frame with 45035 rows and 7 columns
}
\source{
\url{https://wwwn.cdc.gov/nchs/nhanes/OtherNhanesData.aspx}
}
\usage{
CDC
}
\description{
By the courtesy of the Center of Disease Control (CDC), cNORM includes human growth data for children and adolescents
age 2 to 25 that can be used to model trajectories of the body mass index and to estimate percentiles for clinical
definitions of under- and overweight. The data stems from the NHANES surveys in the US and was published in 2012
as public domain. The data was cleaned by removing missing values and it includes the following variables from or
based on the original dataset.
}
\references{
CDC (2012). National Health and Nutrition Examination Survey: Questionnaires, Datasets and Related
Documentation. available \url{https://wwwn.cdc.gov/nchs/nhanes/OtherNhanesData.aspx} (date of retrieval: 25/08/2018)
}
\concept{Body Mass Index growth curves weight height}
\keyword{datasets}
