% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\name{checkConsistency}
\alias{checkConsistency}
\title{Check the consistency of the norm data model}
\usage{
checkConsistency(
  model,
  minAge = NULL,
  maxAge = NULL,
  minNorm = NULL,
  maxNorm = NULL,
  minRaw = NULL,
  maxRaw = NULL,
  stepAge = NULL,
  stepNorm = 1,
  warn = FALSE,
  silent = FALSE
)
}
\arguments{
\item{model}{The model from the bestModel function or a cnorm object}

\item{minAge}{Age to start with checking}

\item{maxAge}{Upper end of the age check}

\item{minNorm}{Lower end of the norm value range}

\item{maxNorm}{Upper end of the norm value range}

\item{minRaw}{clipping parameter for the lower bound of raw scores}

\item{maxRaw}{clipping parameter for the upper bound of raw scores}

\item{stepAge}{Stepping parameter for the age check.
values indicate higher precision / closer checks}

\item{stepNorm}{Stepping parameter for the norm table check within age with lower
scores indicating a higher precision. The choice depends of the norm scale
used. With T scores a stepping parameter of 1 is suitable}

\item{warn}{If set to TRUE, already minor violations of the model assumptions
are displayed (default = FALSE)}

\item{silent}{turn off messages}
}
\value{
Boolean, indicating model violations (TRUE) or no problems (FALSE)
}
\description{
While abilities increase and decline over age, within one age group, the
norm scores always have to show a monotonic increase or decrease with increasing raw
scores. Violations of this assumption are an indication for problems
in modeling the relationship between raw and norm scores. There are
several reasons, why this might occur:
\enumerate{
  \item Vertical extrapolation: Choosing extreme norm scores, e. g. values
  -3 <= x and x >= 3 In order to model these extreme values, a large sample
  dataset is necessary.
  \item Horizontal extrapolation: Taylor polynomials converge in a certain
  radius. Using the model values outside the original dataset may
  lead to inconsistent results.
  \item The data cannot be modeled with Taylor polynomials, or you need
  another power parameter (k) or R2 for the model.
 }
}
\details{
In general, extrapolation (point 1 and 2) can carefully be done to a
 certain degree outside the original sample, but it should in general
 be handled with caution. Please note that at extreme values, the models
 most likely become independent and it is thus recommended to restrict the
 norm score range to the relevant range of abilities, e.g. +/- 2.5 SD via
 the minNorm and maxNorm parameter.
}
\examples{
model <- cnorm(raw = elfe$raw, group = elfe$group, plot = FALSE)
modelViolations <- checkConsistency(model, minNorm = 25, maxNorm = 75)
plotDerivative(model, minNorm = 25, maxNorm = 75)

}
\seealso{
Other model: 
\code{\link{bestModel}()},
\code{\link{cnorm.cv}()},
\code{\link{derive}()},
\code{\link{modelSummary}()},
\code{\link{print.cnorm}()},
\code{\link{printSubset}()},
\code{\link{rangeCheck}()},
\code{\link{regressionFunction}()},
\code{\link{summary.cnorm}()}
}
\concept{model}
