% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shash.R
\name{summary.cnormShaSh}
\alias{summary.cnormShaSh}
\title{Summarize a Sinh-Arcsinh Continuous Norming Model}
\usage{
\method{summary}{cnormShaSh}(object, ...)
}
\arguments{
\item{object}{An object of class "cnormShaSh", typically the result of a call to
\code{\link{cnorm.shash}}.}

\item{...}{Additional arguments passed to the summary method:
\itemize{
   \item age An optional numeric vector of age values corresponding to the raw scores.
     If provided along with \code{score}, additional fit statistics (R-squared, RMSE, bias)
     will be calculated.
   \item score An optional numeric vector of raw scores. Must be provided if \code{age} is given.
   \item weights An optional numeric vector of weights for each observation.
 }}
}
\value{
Invisibly returns a list containing detailed diagnostic information about the model.
  The function primarily produces printed output summarizing the model.
}
\description{
This function provides a summary of a fitted Sinh-Arcsinh continuous norming model,
including model fit statistics, convergence information, and parameter estimates.
}
\details{
The summary includes:
\itemize{
  \item Basic model information (polynomial degrees, delta parameter, number of observations)
  \item Model fit statistics (log-likelihood, AIC, BIC)
  \item R-squared, RMSE, and bias (if age and raw scores are provided)
  \item Convergence information
  \item Parameter estimates with standard errors, z-values, and p-values
}
}
\examples{
\dontrun{
model <- cnorm.shash(children$age, children$score)
summary(model)

# Including R-squared, RMSE, and bias in the summary:
summary(model, age = children$age, score = children$score)
}

}
\seealso{
\code{\link{cnorm.shash}}, \code{\link{diagnostics.shash}}
}
