% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators_weights.R
\name{calculateWeightsPCA}
\alias{calculateWeightsPCA}
\title{Calculate composite weights using principal component analysis (PCA)}
\usage{
calculateWeightsPCA(
 .S                 = args_default()$.S,
 .csem_model        = args_default()$.csem_model
  )
}
\arguments{
\item{.S}{The (K x K) empirical indicator correlation matrix.}

\item{.csem_model}{A (possibly incomplete) \link{cSEMModel}-list.}
}
\value{
A named list. J stands for the number of constructs and K for the number
of indicators.
\describe{
\item{\verb{$W}}{A (J x K) matrix of estimated weights.}
\item{\verb{$E}}{\code{NULL}}
\item{\verb{$Modes}}{The mode used. Always "PCA".}
\item{\verb{$Conv_status}}{\code{NULL} as there are no iterations}
\item{\verb{$Iterations}}{0 as there are no iterations}
}
}
\description{
Calculate weights for each block by extracting the first principal component
of the indicator correlation matrix S_jj for each blocks, i.e., weights
are the simply the first eigenvector of S_jj.
}
