% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_foreman.R
\name{setDominantIndicator}
\alias{setDominantIndicator}
\title{Internal: Set the dominant indicator}
\usage{
setDominantIndicator(
 .W                   = args_default()$.W,
 .dominant_indicators = args_default()$.dominant_indicators, 
 .S                   = args_default()$.S
 )
}
\arguments{
\item{.W}{A (J x K) matrix of weights.}

\item{.dominant_indicators}{A character vector of \code{"construct_name" = "indicator_name"} pairs,
where \code{"indicator_name"} is a character string giving the name of the dominant indicator
and \code{"construct_name"} a character string of the corresponding construct name.
Dominant indicators may be specified for a subset of the constructs.
Default to \code{NULL}.}

\item{.S}{The (K x K) empirical indicator correlation matrix.}
}
\value{
The (J x K) matrix of weights with the dominant indicator set.
}
\description{
Set the dominant indicator for each construct. Since the sign of the weights,
and thus the loadings is often not determined, a dominant indicator can be chosen
per block. The sign of the weights are chosen that the correlation between the
dominant indicator and the composite is positive.
}
\keyword{internal}
