% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_summarize.R
\name{calculateEffects}
\alias{calculateEffects}
\title{Internal: Calculate direct, indirect and total effect}
\usage{
calculateEffects(
 .object       = NULL,
 .output_type  = c("data.frame", "matrix")
)
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}

\item{.output_type}{Character string. The type of output to return. One of
"\emph{complete}" or "\emph{structured}". See the Value section for details. Defaults to
"\emph{complete}".}
}
\value{
A matrix or a data frame of effects.
}
\description{
The direct effects are equal to the estimated coefficients. The total effect
equals (I-B)^{-1}Gamma. The indirect effect equals the difference between
the total effect and the indirect effect. In addition, the variance accounted
for (VAF) is calculated. The VAF is defined as the ratio of a variables
indirect effect to its total effect. Helper for generic functions \code{\link[=summarize]{summarize()}} and \code{\link[=assess]{assess()}}.
}
\seealso{
\code{\link[=assess]{assess()}}, \code{\link[=summarize]{summarize()}} \link{cSEMResults}
}
\keyword{internal}
