% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_estimators_weights.R
\name{calculateOuterWeightsPLS}
\alias{calculateOuterWeightsPLS}
\title{Internal: Calculate the outer weights for PLS-PM}
\usage{
calculateOuterWeightsPLS(
   .data   = args_default()$.data,  
   .S      = args_default()$.S,
   .W      = args_default()$.W,
   .E      = args_default()$.E,
   .modes  = args_default()$.modes
   )
}
\arguments{
\item{.data}{A \code{data.frame} or a \code{matrix} of standardized or unstandardized
data (indicators/items/manifest variables). Possible column types or classes
of the data provided are: "\code{logical}", "\code{numeric}" ("\code{double}" or "\code{integer}"),
"\code{factor}" ("\code{ordered}" and/or "\code{unordered}"), "\code{character}" (converted to factor),
or a mix of several types.}

\item{.S}{The (K x K) empirical indicator correlation matrix.}

\item{.W}{A (J x K) matrix of weights.}

\item{.E}{A (J x J) matrix of inner weights.}

\item{.modes}{A vector giving the mode for each construct in the form \code{"name" = "mode"}.
Only used internally.}
}
\value{
A (J x K) matrix of outer weights.
}
\description{
Calculates outer weights in PLS-PM. Currently, the originally suggested mode A
and mode B are suggested. Additionally, non-negative least squares (modeBNNLS) and
weights of principal component analysis (PCA) are implemented.
}
\keyword{internal}
