\name{unmll}
\alias{case2.unmll.optim}
\alias{case2.gr}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Negative loglikelihood function and the Gradient
%%  ~~ Calculate the negative likelihood function value ~~
}
\description{Calculate the negative loglikelihood function as the 
objective function to be minimize in terms of coefficients \eqn{\beta}'s. The mean and variance 
parameters are bivariate, while the skewness parameter is univariate. The gradient is calculated by a closed form.  
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
}
\usage{
case2.unmll.optim(beta, dataone, Basis.list, cate = 1)
case2.gr(beta, dataone, Basis.list, cate = 1)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{beta}{smoothing coefficients as a vector
%%     ~~Describe \code{beta} here~~
}
  \item{dataone}{observation as a matrix \code{n} by \code{m} (\code{n}: number of subjects; \code{m}: number of timepoints)
%%     ~~Describe \code{dataone} here~~
}
  \item{Basis.list}{a list of 3 components corresponding to smooth matrices for (mu, logvar, and skewness), typically generated by \code{\link{kpbb}}
%%     ~~Describe \code{Basis.list} here~~
}
  \item{cate}{category of model to be considered; 1 for full model, 2 for the model when the skewness is fixed at 0 (no skewness)
%%     ~~Describe \code{cate} here~~
}
}
\details{
The coefficient \code{beta} is a vector by combining all coefficients for the mean, variance and skewness. 
}
\value{
\item{case2.unmll.optim}{negative loglikehood at beta when \code{data = dataone} and the \code{Basis.list} is used}
\item{case2.gr}{gradient vector of \code{case2.unmll.optim} at beta when \code{data = dataone} and the \code{Basis.list} is used} 
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
}
\references{
[1]. Meng Li, Ana-Maria Staicu and Howard D. Bondell (2013), Incorporating Covariates in Skewed Functional Data Models. 
Unpublished. 
}

\note{
This is the negative log Marginal likelihood function of the data assuming independence. 
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{\code{\link{kpbb}}
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
data(data.simulation)
y <- DST$obs
tp <- DST$tp
cp <- DST$cp
# generate basis
cases = c(2,2,1)   # bivariate for mean and variance; univariate for shape 
nknots.tp = c(2,2,2) # 2 knots at time direction for each parameter
nknots.cp = c(2,2)   # 2 knots at covariate direction for mean and variance
basis.list <- lapply(1:3, function(k) 
  kpbb(tp, cp, nknots.tp = nknots.tp[k],
       nknots.cp= nknots.cp[k], sub.case=cases[k]))
# obtain coefficients randomly
length.beta <- sum(sapply(basis.list, ncol))
beta <- runif(length.beta)
unmll <- case2.unmll.optim(beta, y, basis.list)
gradient <- case2.gr(beta, y, basis.list)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{likelihood}
\keyword{gradient}% __ONLY ONE__ keyword per line
